<?php

namespace App\Http\Controllers\Backend;

use App\Models\Customer;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use RealRashid\SweetAlert\Facades\Alert;

class CustomerController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('role:Super Admin');
    }

    /**
     * @param Request $request
     */
    public function index(Request $request)
    {
        $data['page_title'] = __('Manage Customer');
        $data['customers'] = Customer::search($request->keyword)->orderByDesc('id')->paginate();
        return view('backend.customers.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $data['page_title'] = __('Create Customer');
        return view('backend.customers.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);

        Customer::create([
            'name' => $request->input('name'),
        ]);

        Alert::success(__('Congratulation'), __('Customer Created Successfully'));
        return to_route('customers.create');
    }

    /**
     * @param $id
     */
    public function edit($id)
    {
        $data['page_title'] = __('Edit Customer');
        $data['customer'] = Customer::findOrFail($id);
        return view('backend.customers.edit', $data);
    }

    /**
     * @param Request $request
     * @param $id
     */
    public function update(Request $request, $id)
    {
        $customer = Customer::findOrFail($id);
        $request->validate([
            'name' => 'required',
        ]);

        $customer->update([
            'name' => $request->input('name'),
        ]);

        Alert::success(__('Congratulation'), __('Customer Updated Successfully'));
        return to_route('customers.index');
    }

    /**
     * @param $id
     */
    public function destroy($id)
    {
        Customer::destroy($id);
        Alert::success(__('Congratulation'), __('Customer Deleted Successfully'));
        return to_route('customers.index');
    }
}
