<?php

namespace App\Http\Controllers;

use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Permission;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $permissions = [
            'projects-create',
            'projects-store',
            'projects-index',
            'projects-edit',
            'projects-update',
            'projects-destroy',
        ];

        $superAdmin = Role::findByName('Super Admin');
        $employee = Role::findByName('Employee');
        foreach ($permissions as $permission) {
            $permission = Permission::create(['name' => $permission]);
            $permission->assignRole($superAdmin);
            $permission->assignRole($employee);
        }

        dd('Done');
    }
}
