<?php

namespace App\Models;

use App\Traits\SearchableTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Customer extends Model
{
    use HasFactory, SearchableTrait;

    /**
     * @var array
     */
    protected $fillable = [
        'name',
        'phone',
    ];

    /**
     * @var array
     */
    protected $searchable = [
        'columns' => [
            'name' => 5,
        ],
    ];
}
