<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;

class SuperAdminRolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::create([
            'name'     => 'Super Admin',
            'email'    => 'super-admin@gmail.com',
            'password' => Hash::make('123456'),
        ]);

        $role = Role::create(['name' => 'Super Admin']);
        Role::create(['name' => 'Employee']);

        $permissions = [
            'role-list',
            'role-create',
            'role-store',
            'role-edit',
            'role-update',
            'role-delete',
            'permission-list',
            'permission-create',
            'permission-store',
            'permission-edit',
            'permission-update',
            'permission-delete',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        $permissions = Permission::pluck('id', 'id')->all();

        $role->syncPermissions($permissions);

        $user->assignRole('Super Admin');
    }
}
