@extends('layouts.backend.auth')
@section('content')
    <!-- Verify pin start-->
    <div class="auth-main">
        <div class="codex-authbox">
            <div class="auth-header">
                <div class="auth-icon"> <i class="fa fab fa-key"></i></div>
                <h3>{{ __('2FA Authentication') }}</h3>
            </div>
            {{--  OTP code start  --}}
            <form method="POST" action="{{ route('two-factor.login') }}" style="display: block;" id="secretCodeForm">
                @csrf
                <div class="form-group">
                    <label for="code">{{ __('OTP Code') }}</label>
                    <input id="code" type="number" maxlength="6" placeholder="{{ __('OTP Code') }}" class="form-control @error('code') is-invalid @enderror" name="code" required autocomplete="current-code">
                    @error('code')
                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                    @enderror
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary mt-1">
                        {{ __('Submit') }}
                    </button>
                    <div class="btn btn-link mt-1" onclick='(displayForm(this, "recovery_form"))'>
                        {{ __('Use Recovery Code') }}
                    </div>
                </div>
            </form>
            {{--  OTP secret start  --}}
            <form method="POST" action="{{ route('two-factor.login') }}" style="display: none;" id="recoveryCodeForm">
                @csrf
                <div class="form-group">
                    <label for="recovery_code">{{ __('Recovery Code') }}</label>
                    <input id="recovery_code" type="password" class="form-control @error('recovery_code') is-invalid @enderror" placeholder="{{ __('Recovery Code:') }}" name="recovery_code" required autocomplete="current-recovery_code">
                    @error('recovery_code')
                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                    @enderror
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary mt-1">
                        {{ __('Submit') }}
                    </button>
                    <div class="btn btn-link mt-1" onclick='( displayForm(this, "secret_code") )'>
                        {{ __('Use OTP Code') }}
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- Verify pin End-->
@endsection
@section('scripts')
    <script>
        let displayForm = (e, type) => {
            if (type == 'recovery_form') {
                document.getElementById('recoveryCodeForm').style.display = "block";
                document.getElementById('secretCodeForm').style.display = "none";
                return true;
            }
            document.getElementById('recoveryCodeForm').style.display = "none";
            document.getElementById('secretCodeForm').style.display = "block";
            return true;
        }
    </script>
@endsection
