@extends('layouts.backend.auth')

@section('content')
    <!-- Login Start-->
    <div class="auth-main">
        <div class="codex-authbox">
            <div class="auth-header">
                <div class="codex-brand" style="margin-bottom: 25px;">
                    <a class="my-back-logo" style="background: #3e71f8; padding: 10px; border-radius: 7px;" href="{{ url('/') }}">
                        <img class="img-fluid light-logo" src="{{ asset('backend/images/logo/dark-logo.png') }}" alt="">
                        <img class="img-fluid dark-logo" src="{{ asset('backend/images/logo/logo.png') }}" alt="">
                    </a>
                </div>
                <h3>@lang('welcome to') <!--{{ config('app.name') }}--> Zaan Tech Ltd.</h3>
            </div>
            <form method="POST" action="{{ route('login') }}">
                @csrf
                <div class="form-group">
                    <label class="form-label">{{ __('Email Address') }}</label>
                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" placeholder="{{ __('Email Address') }}" value="{{ old('email') }}" required autocomplete="email" autofocus>
                    @error('email')
                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                    @enderror
                </div>
                <div class="form-group">
                    <label class="form-label" for="Password">{{ __('Password') }}</label>
                    <div class="input-group group-input">
                        <input class="form-control showhide-password @error('password') is-invalid @enderror" id="password" name="password" type="password" placeholder="{{ __('Password') }}" required autocomplete="current-password"><span class="input-group-text toggle-show fa fa-eye"></span>
                        @error('password')
                            <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                        @enderror
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="auth-remember">
                        <div class="form-check custom-chek">
                            <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                            <label class="form-check-label" for="remember">{{ __('Remember Me') }}</label>
                        </div><a class="text-primary f-pwd" href="{{ route('password.request') }}">{{ __('Forgot Your Password?') }}</a>
                    </div>
                </div>
                <div class="form-group">
                    <button class="btn btn-primary" type="submit"><i class="fa fa-sign-in"></i> {{ __('Login') }}</button>
                </div>
            </form>
        </div>
    </div>
    <!-- Login End-->
@endsection
