@extends('layouts.backend.auth')

@section('content')
    <div class="auth-main">
        <div class="codex-authbox">
            <div class="auth-header">
                <div class="auth-icon"> <i class="fa fab fa-key"></i></div>
                <h3>{{ __('Confirm Password') }}</h3>
                <p>{{ __('Please confirm your password before continuing.') }}</p>
            </div>
            {{--  OTP code start  --}}
            <form method="POST" action="{{ route('password.confirm') }}">
                @csrf
                <div class="form-group">
                    <label for="password">{{ __('Password') }}</label>
                    <input id="password" type="password" placeholder="{{ __('Password') }}" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">
                    @error('password')
                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                    @enderror
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary mt-1">{{ __('Confirm Password') }}</button>
                </div>
            </form>
        </div>
    </div>
@endsection
