@extends('layouts.backend.auth')

@section('content')
    <!-- New Password Start-->
    <div class="auth-main">
        <div class="codex-authbox">
            <div class="auth-header">
                <div class="auth-icon"><i class="fa fa-unlock-alt"></i></div>
                <h3>@lang('reset your password') </h3>
                <p>@lang('You have Successfully Verified Your Account. Enter your New Password Below.')</p>
            </div>
            <form method="POST" action="{{ route('password.update') }}">
                @csrf
                <input type="hidden" name="token" value="{{ $token }}">

                <div class="form-group">
                    <label class="form-label">{{ __('Email Address') }}</label>
                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" placeholder="{{ __('Email Address') }}" value="{{ request()->email ?? old('email') }}" required autocomplete="email">
                    @error('email')
                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                    @enderror
                </div>
                <div class="form-group">
                    <label class="form-label" for="Password">{{ __('Password') }}</label>
                    <div class="input-group group-input">
                        <input class="form-control showhide-password @error('password') is-invalid @enderror" id="password" name="password" type="password" placeholder="{{ __('Password') }}" required autocomplete="new-password"><span class="input-group-text toggle-show fa fa-eye"></span>
                        @error('password')
                            <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                        @enderror
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label" for="Password-confirm">{{ __('Confirm Password') }}</label>
                    <div class="input-group group-input">
                        <input class="form-control showhide-password2" id="Password-confirm" name="password_confirmation" type="password" placeholder="{{ __('Confirm Password') }}" required autocomplete="new-password">
                        <span class="input-group-text toggle-show2 fa fa-eye"></span>
                    </div>
                </div>
                <div class="form-group mb-0">
                    <button class="btn btn-primary" type="submit">@lang('Update Password')</button>
                </div>
            </form>
        </div>
    </div>
    <!-- New Password End-->
@endsection
