@extends('layouts.backend.master')
@section('plugin-style')
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2/css/select2-bootstrap-5-theme.min.css') }}">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection
@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="card">
                    <div class="card-header">
                        <h4>{{ $page_title }}</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('report.index') }}" method="get">

                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="customer" class="form-label">@lang('Select Customer')</label>
                                    <select name="customer" id="customer" class="form-control select2">
                                        <option value="0">@lang('All Customer')</option>
                                        @foreach ($customers as $customer)
                                            <option value="{{ $customer->id }}" @selected(request()->customer == $customer->id)>{{ $customer->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('customer')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="employee" class="form-label">@lang('Select Employee')</label>
                                    <select name="employee" id="employee" class="form-control select2">
                                        <option value="0">@lang('All Employee')</option>
                                        @foreach ($employees as $employee)
                                            <option value="{{ $employee->id }}" @selected(request()->employee == $employee->id)>
                                                {{ $employee->name }} -- {{ $employee->email }}</option>
                                        @endforeach
                                    </select>
                                    @error('employee')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="status" class="form-label">@lang('Select Status')</label>
                                    <select name="status" id="status" class="form-control select2">
                                        <option value="">@lang('All Status')</option>
                                        <option value="0" @selected(request()->status == '0')>@lang('Opened')</option>
                                        <option value="1" @selected(request()->status == '1')>@lang('Closed')</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="daterange" class="form-label">@lang('Select Date Range')</label>
                                    <input type="text" name="daterange" readonly id="daterange"
                                           value="{{ request()->daterange ?? '' }}"
                                           placeholder="@lang('Select Date Range')"
                                           class="form-control @error('daterange') is-invalid @enderror" required>
                                    @error('daterange')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                            </div>

                            <button class="btn btn-primary btn-block" style="width: 100%" type="submit"><i
                                   class="fa fa-filter"></i> @lang('Filter Now')</button>
                        </form>
                        <hr>
                        @if ($projects->count())
                            <div class="text-center">
                                <h3>@lang('Date Start'): {{ $startDate }}</h3>
                                <h3>@lang('Date End'): {{ $endDate }}</h3>
                                <h3>@lang('Employee')
                                    : {{ $semployee->count() ? $semployee->name : __('All Employee') }}</h3>
                                <h3>@lang('Customer')
                                    : {{ $scustomer->count() ? $scustomer->name : __('All Customer') }}</h3>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-6">
                                    <form action="{{ route('report.pdf') }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="startDate" value="{{ $startDate }}">
                                        <input type="hidden" name="endDate" value="{{ $endDate }}">
                                        <input type="hidden" name="employee" value="{{ request()->employee }}">
                                        <input type="hidden" name="customer" value="{{ request()->customer }}">
                                        <input type="hidden" name="status" value="{{ request()->status }}">
                                        <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fa fa-file-pdf-o"></i> @lang('Export as PDF')</button>
                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-danger deleteButton" type="button"
                                            data-bs-toggle="modal" data-bs-target="#deleteModal" style="width: 100%;"><i
                                           class="fa fa-trash"></i> @lang('Clear All Data')</button>
                                </div>
                            </div>
                            <hr>
                        @endif
                        <table class="table table-bordered table-stripe">
                            <thead>
                                <tr>
                                    <th>@lang('SL')</th>
                                    <th>@lang('Customer Information')</th>
                                    <th>@lang('Project Code')</th>
                                    @role('Super Admin')
                                        <th>@lang('Employee Information')</th>
                                    @endrole
                                    <th>@lang('Start Date')</th>
                                    {{--  <th>@lang('Start Photo')</th>  --}}
                                    <th>@lang('End Date')</th>
                                    {{--  <th>@lang('End Photo')</th>  --}}
                                    <th>@lang('Stating Quantity')</th>
                                    <th>@lang('Final Quantity')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($projects as $key => $project)
                                    <tr>
                                        <td>{{ $projects->total() - (--$key + $projects->firstItem()) }}</td>
                                        <td>{{ $project->customer->name }}</td>
                                        <td>{{ $project->code }}</td>
                                        @role('Super Admin')
                                            <td>{{ $project->employee->name }} <br> {{ $project->employee->email }}</td>
                                        @endrole
                                        <td>
                                            @role('Super Admin')
                                                {{ $project->start_date->toDateTimeString() }}
                                            @else
                                                {{ $project->start_date->toDateString() }}
                                            @endrole
                                        </td>
                                        <td>
                                            @role('Super Admin')
                                                {{ $project->end_date ? $project->end_date->toDateTimeString() : 'N/A' }}
                                            @else
                                                {{ $project->end_date ? $project->end_date->toDateString() : 'N/A' }}
                                            @endrole
                                        </td>
                                        <td>{{ $project->start_qty }} </td>
                                        <td>{{ $project->final_qty ?: 'N/A' }}</td>
                                        <td>
                                            @if ($project->status == 1)
                                                <span class="badge badge-success m-2">{{ __('Closed') }}</span>
                                            @else
                                                <span class="badge badge-primary m-2">{{ __('Opened') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-lg">
                                                <a href="{{ route('projects.show', $project->id) }}"
                                                   class="btn btn-outline-success" role="button" title="@lang('View')"><i
                                                       class="fa fa-eye"></i></a>
                                                @if (auth()->user()->hasRole('Employee') && $project->end_date == null)
                                                    <a href="{{ route('projects.edit', $project->id) }}"
                                                       class="btn btn-outline-primary" title="@lang('Edit')"><i
                                                           class="fa fa-edit"></i></a>
                                                @endif
                                                @role('Super Admin')
                                                    <a href="{{ route('projects.edit', $project->id) }}"
                                                       class="btn btn-outline-primary" title="@lang('Edit')"><i
                                                           class="fa fa-edit"></i></a>
                                                    <button type="button" data-bs-toggle="modal" data-bs-target="#deleteModal"
                                                            data-id="{{ $project->id }}"
                                                            class="btn btn-outline-danger deleteButton" type="button"
                                                            title="@lang('Delete')"><i class="fa fa-trash"></i></button>
                                                @endrole
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="100%" class="text-center">@lang('No Project Found')</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        @if ($projects->isNotEmpty())
                            @if ($projects->hasPages())
                                <div class="pagination-wrapper mt-10">
                                    {!! $projects->withQueryString()->links() !!}
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--  Discuss delete modal  --}}
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
         aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('report.delete') }}" method="post">
                @csrf
                @method('DELETE')
                @if ($projects->count())
                    <input type="hidden" name="startDate" value="{{ $startDate }}">
                    <input type="hidden" name="endDate" value="{{ $endDate }}">
                    <input type="hidden" name="employee" value="{{ request()->employee }}">
                    <input type="hidden" name="customer" value="{{ request()->customer }}">
                @endif
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i
                               class="fa fa-exclamation-triangle"></i> @lang('Confirmation')</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3>@lang('Are you sure to delete this report data?')</h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">@lang('Close')</button>
                        <button class="btn btn-primary ml-10" type="submit">@lang('Yes Delete')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('plugin-script')
    <script src="{{ asset('backend/plugins/select2/js/select2.min.js') }}"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
@endsection
@section('script')
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'bootstrap-5'
            });
            $('input[name="daterange"]').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'Y-MM-DD',
                    "separator": " -- ",
                }
            });
            $('input[name="daterange"]').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' -- ' + picker.endDate.format('YYYY-MM-DD'));
            });

            $('input[name="daterange"]').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
        });
    </script>
@endsection
