@extends('layouts.backend.master')

@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ $page_title }}</h4>
                            <form action="{{ route('employees.index') }}" method="get">
                                <input type="search" name="keyword" class="p-10 rounded" value="{{ request()->keyword ?? '' }}" placeholder="@lang('Search Employee')">
                            </form>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>@lang('SL')</th>
                                        <th>@lang('Name')</th>
                                        <th>@lang('Email')</th>
                                        <th>@lang('Action')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($employees as $key => $employee)
                                        <tr>
                                            <td>{{ $key + $employees->firstItem() }}</td>
                                            <td>{{ $employee->name }}</td>
                                            <td>{{ $employee->email }}</td>
                                            <td>
                                                <a href="{{ route('employees.edit', $employee->id) }}" class="btn btn-primary btn-md"><i class="fa fa-edit"></i> @lang('Edit')</a>
                                                <button class="btn btn-danger btn-md deleteButton" type="button" data-bs-toggle="modal" data-id="{{ $employee->id }}" data-bs-target="#deleteModal"><i class="fa fa-trash"></i> @lang('Delete')</button>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td class="text-center" colspan="100%">@lang('No Employee Found')</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                            @if ($employees->hasPages())
                                <div class="pagination-wrapper mt-10">
                                    {!! $employees->links() !!}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--  Delete Employee modal  --}}
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" method="post" id="deleteForm">
                @csrf
                @method('DELETE')
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i class="fa fa-exclamation-triangle"></i> Confirmation.!</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="fa fa-times"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3>@lang('Are you sure to delete this employee?')</h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">@lang('Close')</button>
                        <button class="btn btn-primary ml-10" type="submit">@lang('Yes Delete')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        $(document).on('click', '.deleteButton', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '{{ route('employees.destroy', ':id') }}';
            $("#deleteForm").attr("action", url.replace(':id', id));
        })
    </script>
@endsection
