@extends('layouts.backend.master')
@section('plugin-style')
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2/css/select2-bootstrap-5-theme.min.css') }}">
@endsection
@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ $page_title }}</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('projects.update', $project->id) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')

                                <div class="form-group">
                                    <label for="customer_type" class="form-label">@lang('Customer Type')</label>
                                    <select name="customer_type" id="customer_type" class="form-control select2" @disabled($readonly)>
                                        <option value="">@lang('Select One')</option>
                                        <option value="1" selected>@lang('Existing Customer')</option>
                                        <option value="2">@lang('New Customer')</option>
                                    </select>
                                    @error('customer_type')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>

                                <div class="form-group" id="exitingCustomer" style="display: block">
                                    <label for="customer_id" class="form-label">@lang('Select Customer')</label>
                                    <select name="customer_id" id="customer_id" class="form-control select2" @disabled($readonly)>
                                        <option value="">@lang('Select Customer')</option>
                                        @foreach ($customers as $customer)
                                            <option value="{{ $customer->id }}" @selected($customer->id == $project->customer_id)>{{ $customer->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>

                                <div id="newCustomer" style="display: none">
                                    <div class="form-group">
                                        <label for="customer_name" class="form-label">@lang('Customer Name')</label>
                                        <input type="text" name="customer_name" id="customer_name" value="{{ old('customer_name') }}" placeholder="@lang('Customer Name')" class="form-control @error('customer_name') is-invalid @enderror">
                                        @error('customer_name')
                                            <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label for="code" class="form-label">@lang('Project Code')</label>
                                        <input type="text" @readonly($readonly) name="code" id="code" value="{{ $project->code }}" placeholder="@lang('Project Code')" class="form-control @error('code') is-invalid @enderror" required>
                                        @error('code')
                                            <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label for="start_qty" class="form-label">@lang('Stating Quantity')</label>
                                        <input type="number" name="start_qty" id="start_qty" value="{{ $project->start_qty }}" @readonly($readonly) placeholder="@lang('Stating Quantity')" class="form-control @error('start_qty') is-invalid @enderror" required>
                                        @error('start_qty')
                                            <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label for="final_qty" class="form-label">@lang('Final Quantity')</label>
                                        <input type="number" name="final_qty" id="final_qty" value="{{ $project->final_qty }}" @readonly($isClose) placeholder="@lang('Final Quantity')" class="form-control @error('final_qty') is-invalid @enderror">
                                        @error('final_qty')
                                            <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    @role('Employee')
                                        <div class="form-group col-md-12">
                                            <label for="attachment" class="form-label">@lang('Attachment')</label>
                                            <input type="file" @disabled($readonly) name="attachment" id="attachment" placeholder="@lang('Attachment')" class="form-control @error('attachment') is-invalid @enderror">
                                            @error('attachment')
                                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                            @enderror
                                        </div>
                                    @endrole

                                    @role('Super Admin')
                                        <div class="form-group col-md-6">
                                            <label for="employee_id" class="form-label">@lang('Assign Employee')</label>
                                            <select name="employee_id" id="employee_id" class="form-control select2">
                                                <option value="">@lang('Select One')</option>
                                                @foreach ($employees as $employee)
                                                    <option value="{{ $employee->id }}" @selected($project->employee_id == $employee->id)>{{ $employee->name }} - {{ $employee->email }}</option>
                                                @endforeach
                                            </select>
                                            @error('employee_id')
                                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                            @enderror
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label for="attachment" class="form-label">@lang('Attachment')</label>
                                            <input type="file" name="attachment" id="attachment" placeholder="@lang('Attachment')" class="form-control @error('attachment') is-invalid @enderror">
                                            @error('attachment')
                                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                            @enderror
                                        </div>
                                    @endrole

                                </div>

                                <div class="form-group">
                                    <label for="note" class="form-label">@lang('Notes')</label>
                                    <textarea name="note" id="note" rows="3" placeholder="@lang('Notes')" @readonly($isClose) class="form-control @error('note') is-invalid @enderror">{{ $project->note }}</textarea>
                                    @error('end_date')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                                <button class="btn btn-primary btn-w-100 col-md-12" type="submit"><i class="fa fa-send"></i> @lang('Update Project')</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('plugin-script')
    <script src="{{ asset('backend/plugins/select2/js/select2.min.js') }}"></script>
@endsection
@section('script')
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'bootstrap-5'
            });

            $('#customer_type').on('change', function(e) {
                var type = $(this).val();
                if (type == 1) {
                    $('#exitingCustomer').css('display', 'block');
                    $('#newCustomer').css('display', 'none');
                } else if (type == 2) {
                    $('#exitingCustomer').css('display', 'none');
                    $('#newCustomer').css('display', 'block');
                } else {
                    $('#exitingCustomer').css('display', 'none');
                    $('#newCustomer').css('display', 'none');
                }
            });
        });
    </script>
@endsection
