@extends('layouts.backend.master')

@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <h4>{{ $page_title }}</h4>
                            <form action="{{ route('projects.index') }}" method="get">
                                <input type="search" name="keyword" class="p-10 rounded" value="{{ request()->keyword ?? '' }}" placeholder="@lang('Search Project')">
                            </form>
                        </div>
                        <div class="card-body">
                            <div class="table-responsived">
                                <table class="table table-bordered table-stripe">
                                    <thead>
                                        <tr>
                                            <th>@lang('SL')</th>
                                            <th>@lang('Customer Information')</th>
                                            <th>@lang('Project Code')</th>
                                            @role('Super Admin')
                                                <th>@lang('Employee Information')</th>
                                            @endrole
                                            <th>@lang('Start Date')</th>
                                            {{--  <th>@lang('Start Photo')</th>  --}}
                                            <th>@lang('End Date')</th>
                                            {{--  <th>@lang('End Photo')</th>  --}}
                                            <th>@lang('Stating Quantity')</th>
                                            <th>@lang('Final Quantity')</th>
                                            <th>@lang('Status')</th>
                                            <th>@lang('Action')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($projects as $key => $project)
                                            <tr>
                                                <td>{{ $projects->total() - (--$key + $projects->firstItem()) }}</td>
                                                <td>{{ $project->customer->name }}</td>
                                                <td>{{ $project->code }}</td>
                                                @role('Super Admin')
                                                    <td>{{ $project->employee->name }} <br> {{ $project->employee->email }}</td>
                                                @endrole
                                                <td>
                                                    @role('Super Admin')
                                                        {{ $project->start_date->toDateTimeString() }}
                                                    @else
                                                        {{ $project->start_date->toDateString() }}
                                                    @endrole
                                                </td>
                                                {{--  <td>
                                                    @if ($project->attachment)
                                                        <img src="{{ asset("storage/projects/$project->attachment") }}" height="50px" width="50px">
                                                    @endif
                                                </td>  --}}
                                                <td>
                                                    @role('Super Admin')
                                                        {{ $project->end_date ? $project->end_date->toDateTimeString() : 'N/A' }}
                                                    @else
                                                        {{ $project->end_date ? $project->end_date->toDateString() : 'N/A' }}
                                                    @endrole
                                                </td>
                                                {{--  <td>
                                                    @if ($project->final_attachment)
                                                        <img src="{{ asset("storage/projects/$project->final_attachment") }}" height="50px" width="50px">
                                                    @endif
                                                </td>  --}}
                                                <td>{{ $project->start_qty }} </td>
                                                <td>{{ $project->final_qty ? $project->final_qty : 'N/A' }}</td>
                                                <td>
                                                    @if ($project->status == 1)
                                                        <span class="badge badge-success m-2">{{ __('Closed') }}</span>
                                                    @else
                                                        <span class="badge badge-primary m-2">{{ __('Opened') }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-lg">
                                                        <a href="{{ route('projects.show', $project->id) }}" class="btn btn-outline-success" role="button" title="@lang('View')"><i class="fa fa-eye"></i></a>
                                                        @if (auth()->user()->hasRole('Employee') && $project->end_date == null)
                                                            <a href="{{ route('projects.edit', $project->id) }}" class="btn btn-outline-primary" title="@lang('Edit')"><i class="fa fa-edit"></i></a>
                                                        @endif
                                                        @role('Super Admin')
                                                            <a href="{{ route('projects.edit', $project->id) }}" class="btn btn-outline-primary" title="@lang('Edit')"><i class="fa fa-edit"></i></a>
                                                            <button type="button" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="{{ $project->id }}" class="btn btn-outline-danger deleteButton" type="button" title="@lang('Delete')"><i class="fa fa-trash"></i></button>
                                                        @endrole
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="100%" class="text-center">@lang('No Project Found')</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                @if ($projects->hasPages())
                                    <div class="pagination-wrapper mt-10">
                                        {!! $projects->links() !!}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--  Discuss delete modal  --}}
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" method="post" id="deleteForm">
                @csrf
                @method('DELETE')
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i class="fa fa-exclamation-triangle"></i> Confirmation.!</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3>@lang('Are you sure to delete this project?')</h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">@lang('Close')</button>
                        <button class="btn btn-primary ml-10" type="submit">@lang('Yes Delete')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).on('click', '.deleteButton', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '{{ route('projects.destroy', ':id') }}';
            $("#deleteForm").attr("action", url.replace(':id', id));
        })
    </script>
@endsection
