@extends('layouts.backend.master')

@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    {{--  Country section  --}}
                    @role('Super Admin')
                        <div class="card">
                            <div class="card-header">
                                <h4>{{ __('Update System Language') }}</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('language.update') }}" method="POST">
                                    @csrf
                                    <div class="form-group">
                                        <label class="form-label" for="name">{{ __('Select Language') }}</label>
                                        <select class="form-control" name="lang">
                                            <option value="en" {{ session()->get('locale') == 'en' ? 'selected' : '' }}>English</option>
                                            <option value="it" {{ session()->get('locale') == 'it' ? 'selected' : '' }}>Italian</option>
                                        </select>
                                    </div>
                                    <button class="btn btn-primary" type="submit"><i class="fa fas fa-language"></i> {{ trans('Update Language') }}</button>
                                </form>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h4>{{ __('Attendance') }}</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('attendance.update') }}" method="POST">
                                    @csrf
                                    <div class="form-group">
                                        <label class="form-label" for="name">{{ __('Select Attendance') }}</label>
                                        <select class="form-control" name="attend">
                                            <option value="1" {{ config('services.attendance') == 'enabled' ? 'selected' : '' }}>@lang('Enabled')</option>
                                            <option value="0" {{ config('services.attendance') == 'disabled' ? 'selected' : '' }}>@lang('Disabled')</option>
                                        </select>
                                    </div>
                                    <button class="btn btn-primary" type="submit"><i class="fa fa-calendar"></i> {{ trans('Save') }}</button>
                                </form>
                            </div>
                        </div>
                    @endrole

                    {{--  Profile section  --}}
                    <div class="card">
                        <div class="card-header">
                            <h4>@lang('Update Profile Information')</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('user-profile-information.update') }}" method="POST">
                                @csrf
                                @method('put')
                                <div class="form-group">
                                    <label class="form-label" for="name">{{ __('Name') }}</label>
                                    <input class="form-control" type="text" id="name" name="name" value="{{ $user->name }}" placeholder="Name">
                                    @error('name')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="email">{{ __('Email Address') }}</label>
                                    <input class="form-control" type="email" id="email" name="email" value="{{ $user->email }}" placeholder="Email">
                                    @error('email')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                                <button class="btn btn-primary" type="submit"><i class="fa fa-send"></i> @lang('Update Information')</button>
                            </form>
                        </div>
                    </div>
                    {{--  Password section  --}}
                    <div class="card">
                        <div class="card-header">
                            <h4>@lang('Update Password')</h4>
                        </div>
                        <div class="card-body">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <form action="{{ route('user-password.update') }}" method="POST">
                                @csrf
                                @method('put')
                                <div class="form-group">
                                    <label class="form-label" for="current-password">{{ __('Current Password') }}</label>
                                    <div class="input-group group-input">
                                        <input class="form-control @error('current_password') is-invalid @enderror" id="current_password" name="current_password" type="password" placeholder="{{ __('Current Password') }}" required autocomplete="current-password">
                                        <span class="input-group-text fa fa-key"></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="Password">{{ __('Password') }}</label>
                                    <div class="input-group group-input">
                                        <input class="form-control showhide-password @error('password') is-invalid @enderror" id="password" name="password" type="password" placeholder="{{ __('Password') }}" required autocomplete="new-password">
                                        <span class="input-group-text toggle-show fa fa-eye"></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="Password-confirm">{{ __('Confirm Password') }}</label>
                                    <div class="input-group group-input">
                                        <input class="form-control showhide-password2" id="Password-confirm" name="password_confirmation" type="password" placeholder="{{ __('Confirm Password') }}" required autocomplete="new-password">
                                        <span class="input-group-text toggle-show2 fa fa-eye"></span>
                                    </div>
                                </div>
                                <button class="btn btn-primary" type="submit"><i class="fa fa-key"></i> @lang('Update Password')</button>
                            </form>
                        </div>
                    </div>
                    {{--  2FA section  --}}
                    <div class="card">
                        <div class="card-header">
                            <h4>@lang('2FA Management')</h4>
                        </div>
                        <div class="card-body">
                            @if (!auth()->user()->two_factor_secret)
                                <form method="post" action="{{ url('/user/two-factor-authentication') }}">
                                    @csrf
                                    <button type="submit" class="btn btn-success">@lang('Click here to Enable 2FA')</button>
                                </form>
                            @else
                                @if (session('status') == 'two-factor-authentication-enabled')
                                    <div class="alert alert-success" role="alert">@lang('Please finish configuring two factor authentication below.')</div>
                                @endif
                                @if (session('status') == 'two-factor-authentication-confirmed')
                                    <div class="alert alert-success" role="alert">@lang('Two factor authentication confirmed and enabled successfully.')</div>
                                @endif
                                {{--  Confirm 2fa now  --}}
                                @if (!auth()->user()->two_factor_confirmed_at)
                                    <div class="pb-3">
                                        {!! auth()->user()->twoFactorQrCodeSvg() !!}
                                    </div>
                                    <div class="mt-10">
                                        <h3 class="py-10">Recovery Codes:</h3>
                                        <ul class="list-group mb-2">
                                            @foreach (json_decode(decrypt(auth()->user()->two_factor_recovery_codes)) as $code)
                                                <li class="list-group-item">{{ $code }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    <form method="post" class="pt-20" action="{{ url('/user/confirmed-two-factor-authentication') }}">
                                        @csrf
                                        <div class="form-group">
                                            <label for="code" class="form-label">@lang('Enter OTP Code')</label>
                                            <input type="text" name="code" id="code" value="{{ old('code') }}" placeholder="@lang('Enter OTP Code')" class="form-control" required>
                                        </div>
                                        <button type="button" class="btn btn-success mb-2">@lang('Click here to Confirm 2FA')</button>
                                    </form>
                                @endif

                                {{--  Disable 2fa now  --}}
                                @if (auth()->user()->two_factor_secret)
                                    <h4 class="py-10">@lang('If you want to remove the 2FA authentication')</h4>
                                    <form method="post" action="{{ url('/user/two-factor-authentication') }}">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger">@lang('Click here to Disable 2FA')</button>
                                    </form>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
