<?php $__env->startSection('content'); ?>
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo e($page_title); ?></h4>
                            <form action="<?php echo e(route('customers.index')); ?>" method="get">
                                <input type="search" name="keyword" class="p-10 rounded" value="<?php echo e(request()->keyword ?? ''); ?>" placeholder="<?php echo app('translator')->get('Search Customer'); ?>">
                            </form>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('SL'); ?></th>
                                        <th><?php echo app('translator')->get('Name'); ?></th>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($key + $customers->firstItem()); ?></td>
                                            <td><?php echo e($customer->name); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('customers.edit', $customer->id)); ?>" class="btn btn-primary btn-md"><i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
                                                <button class="btn btn-danger btn-md deleteButton" type="button" data-bs-toggle="modal" data-id="<?php echo e($customer->id); ?>" data-bs-target="#deleteModal"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td class="text-center" colspan="100%"><?php echo app('translator')->get('No Customer Found'); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <?php if($customers->hasPages()): ?>
                                <div class="pagination-wrapper mt-10">
                                    <?php echo $customers->links(); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" method="post" id="deleteForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i class="fa fa-exclamation-triangle"></i> <?php echo app('translator')->get('Confirmation'); ?></h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="fa fa-times"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3><?php echo app('translator')->get('Are you sure to delete this customer?'); ?></h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button class="btn btn-primary ml-10" type="submit"><?php echo app('translator')->get('Yes Delete'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).on('click', '.deleteButton', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '<?php echo e(route('customers.destroy', ':id')); ?>';
            $("#deleteForm").attr("action", url.replace(':id', id));
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xbgqgjmd/public_html/resources/views/backend/customers/index.blade.php ENDPATH**/ ?>