<?php $__env->startSection('plugin-style'); ?>
    <link href="<?php echo e(asset('backend/plugins/lightbox/css/lightbox.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo e($page_title); ?></h4>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-stripe">
                                <thead>
                                    <tr>
                                        <th width="30%" class="text-end"><?php echo app('translator')->get('Title'); ?></th>
                                        <th><?php echo app('translator')->get('Information'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Project Code')); ?></td>
                                        <td><?php echo e($project->code); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Customer Information')); ?></td>
                                        <td><?php echo e($project->customer->name); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Start Date')); ?></td>
                                        <td>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                <?php echo e($project->start_date->toDateTimeString()); ?>

                                            <?php else: ?>
                                                <?php echo e($project->start_date->toDateString()); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Finish Date')); ?></td>
                                        <td>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                <?php echo e($project->end_date ? $project->end_date->toDateTimeString() : 'N/A'); ?>

                                            <?php else: ?>
                                                <?php echo e($project->end_date ? $project->end_date->toDateString() : 'N/A'); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Stating Quantity')); ?></td>
                                        <td><?php echo e($project->start_qty); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Final Quantity')); ?></td>
                                        <td><?php echo e($project->final_qty ? $project->final_qty : 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Initial Photo')); ?></td>
                                        <td>

                                            <?php if($project->attachment): ?>
                                                <?php $att = explode('.',$project->attachment) ?>
                                                <?php if($att[1] == 'png' || $att[1] == 'jpeg' || $att[1] == 'jpg'): ?>
                                                    <a href="<?php echo e(asset("storage/projects/$project->attachment")); ?>" class="badge badge-success" data-lightbox="<?php echo e($project->code); ?>" data-title="<?php echo e($project->customer->name); ?> - <?php echo e($project->customer->phone); ?>">
                                                        <img src="<?php echo e(asset("storage/projects/$project->attachment")); ?>" height="100px" width="100px">
                                                    </a>
                                                <?php else: ?>
                                                    <p class="text-danger"><?php echo app('translator')->get('This format not previewable'); ?></p>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo e(__('Notes')); ?></td>
                                        <td><?php echo e($project->note); ?></td>
                                    </tr>

                                    <?php if($project->end_date): ?>
                                        <tr>
                                            <td class="text-end"><?php echo e(__('Final Photo')); ?></td>
                                            <td>
                                                <a href="<?php echo e(asset("storage/projects/$project->final_attachment")); ?>" class="badge badge-success" data-lightbox="<?php echo e($project->code); ?>__" data-title="<?php echo e($project->customer->name); ?>">
                                                    <img src="<?php echo e(asset("storage/projects/$project->final_attachment")); ?>" height="100px" width="100px">
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-end"><?php echo e(__('Final Note')); ?></td>
                                            <td><?php echo e($project->final_note); ?></td>
                                        </tr>
                                    <?php endif; ?>

                                    <tr>
                                        <td class="text-end"><?php echo e(__('Status')); ?></td>
                                        <td>
                                            <?php if($project->status == 1): ?>
                                                <span class="badge badge-success m-2"><?php echo e(__('Closed')); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-primary m-2"><?php echo e(__('Opened')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <?php if(auth()->user()->hasRole('Employee') && $project->end_date == null): ?>
                                        <tr>
                                            <td class="text-end"><?php echo e(__('Action')); ?></td>
                                            <td>
                                                <button type="button" class="btn btn-outline-success btn-md m-2 live_capture"><i class="fa fa-check"></i> <?php echo e(__('Close Project')); ?></button>
                                                <a href="<?php echo e(route('projects.pdf', $project->id)); ?>" class="btn btn-outline-primary btn-md text-success"><i class="fa fa-file-pdf-o"></i> <?php echo app('translator')->get('Export as PDF'); ?></a>
                                                <?php if($project->attachment): ?>
                                                    <a href="<?php echo e(route('projects.download', $project->id)); ?>" class="btn btn-outline-success btn-md"><i class="fa fa-download"></i> <?php echo app('translator')->get('Download Initial Photo'); ?></a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                        <tr>
                                            <td class="text-end"><?php echo e(__('Action')); ?></td>
                                            <td>
                                                <button type="button" class="btn btn-outline-success btn-md m-2 live_capture"><i class="fa fa-check"></i> <?php echo e(__('Close Project')); ?></button>
                                                <a href="<?php echo e(route('projects.pdf', $project->id)); ?>" class="btn btn-outline-primary btn-md text-success"><i class="fa fa-file-pdf-o"></i> <?php echo app('translator')->get('Export as PDF'); ?></a>
                                                <?php if($project->attachment): ?>
                                                    <a href="<?php echo e(route('projects.download', $project->id)); ?>" class="btn btn-outline-success btn-md"><i class="fa fa-download"></i> <?php echo app('translator')->get('Download Initial Photo'); ?></a>
                                                <?php endif; ?>
                                                <?php if($project->final_attachment): ?>
                                                    <a href="<?php echo e(route('projects.final-download', $project->id)); ?>" class="btn btn-outline-primary btn-md"><i class="fa fa-download"></i> <?php echo app('translator')->get('Download Final Photo'); ?></a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <div class="d-flex justify-content-between mt-20">
                                <h3><?php echo e(__('Discussions')); ?></h3>
                                <div class="text-left bg-transparent">
                                    <button type="button" class="btn btn-primary btn-md m-2" data-bs-toggle="modal" data-bs-target="#addNewDiscuss"><i class="fa fa-plus"></i> <?php echo e(__('Add Discussion')); ?></button>
                                </div>
                            </div>

                            <div class="table-responsive mt-20">
                                <table id="ul-contact-list" class="display table p-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Created By')); ?></th>
                                            <th><?php echo app('translator')->get('Role'); ?></th>
                                            <th><?php echo e(__('Message')); ?></th>
                                            <th><?php echo e(__('Attachment')); ?></th>
                                            <th><?php echo e(__('Date')); ?></th>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                <th><?php echo e(__('Action')); ?></th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $project->discussions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discussion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($discussion->user->name); ?> <br><?php echo e($discussion->user->email); ?></td>
                                                <td><?php echo e($discussion->user->getRoleNames()->first()); ?></td>
                                                <td><?php echo e($discussion->message); ?></td>
                                                <td>
                                                    <?php if($discussion->attachment): ?>
                                                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                            <a href="<?php echo e(route('projects.discussions.download', $discussion->id)); ?>" class="badge badge-success"><?php echo app('translator')->get('Download'); ?></a>
                                                        <?php endif; ?>
                                                        <?php $att = explode('.',$discussion->attachment) ?>
                                                        <?php if($att[1] == 'png' || $att[1] == 'jpeg' || $att[1] == 'jpg'): ?>
                                                            <a href="<?php echo e(asset("storage/discussions/$discussion->attachment")); ?>" class="badge badge-success" data-lightbox="<?php echo e($discussion->id); ?>" data-title="<?php echo e($discussion->message); ?>"><?php echo e(__('Preview')); ?></a>
                                                        <?php else: ?>
                                                            <p class="text-danger"><?php echo app('translator')->get('This format not previewable'); ?></p>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        N/A
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($discussion->created_at); ?></td>
                                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-danger deleteButton" data-id="<?php echo e($discussion->id); ?>" data-bs-toggle="modal" data-bs-target="#deleteModal" title="Delete">
                                                            <i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?>
                                                        </button>
                                                    </td>
                                                <?php endif; ?>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="addNewDiscuss" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addNewDiscussLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <form action="<?php echo e(route('projects.discussions')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="project_id" value="<?php echo e($project->id); ?>">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addNewDiscussLabel"><?php echo app('translator')->get('Add New Discuss'); ?></h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="message" class="form-label"><?php echo app('translator')->get('Message'); ?>:</label>
                            <textarea name="message" id="message" rows="3" placeholder="<?php echo app('translator')->get('Message'); ?>" class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('message')); ?></textarea>
                            <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="attachment" class="form-label"><?php echo app('translator')->get('Attachment'); ?>:</label>
                            <input type="file" name="attachment" id="attachment" placeholder="<?php echo app('translator')->get('Attachment'); ?>" class="form-control <?php $__errorArgs = ['attachment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['attachment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button class="btn btn-primary ml-10" type="submit"><?php echo app('translator')->get('Save'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <div class="modal fade" id="closeModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="closeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-xl">
            <form action="<?php echo e(route('projects.close')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="project_id" value="<?php echo e($project->id); ?>">
                <input type="hidden" name="capture_image" class="capture_image">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addNewDiscussLabel"><?php echo app('translator')->get('Close Project'); ?></h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3 class="mb-10 text-danger"><?php echo app('translator')->get('Are you sure want to close this project?'); ?></h3>
                        <div class="form-group">
                            <label for="final_quantity" class="form-label"><?php echo app('translator')->get('Final Quantity'); ?>:</label>
                            <input type="number" name="final_quantity" id="final_quantity" placeholder="<?php echo app('translator')->get('Final Quantity'); ?>" value="<?php echo e(old('final_quantity')); ?>" class="form-control <?php $__errorArgs = ['final_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <?php $__errorArgs = ['final_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="attachment" class="form-label"><?php echo app('translator')->get('Attachment'); ?>:</label>
                                <input type="file" name="final_attachment" id="attachment" placeholder="<?php echo app('translator')->get('Attachment'); ?>" onchange="loadFile(event)" class="form-control <?php $__errorArgs = ['attachment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__errorArgs = ['attachment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-12">
                                <label for="preview" class="form-label"><?php echo app('translator')->get('Preview'); ?>:</label> <br>
                                <img id="output" style="max-width:100% !important" />
                            </div>
                            
                        </div>

                        <div class="form-group">
                            <label for="final_note" class="form-label"><?php echo app('translator')->get('Note'); ?>:</label>
                            <textarea name="final_note" id="final_note" rows="3" placeholder="<?php echo app('translator')->get('Note'); ?>" class="form-control <?php $__errorArgs = ['final_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('final_note')); ?></textarea>
                            <?php $__errorArgs = ['final_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary closeModal" type="button"><?php echo app('translator')->get('Close'); ?></button>
                        <button class="btn btn-primary ml-10" type="submit"><?php echo app('translator')->get('Save'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" method="post" id="deleteForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i class="fa fa-exclamation-triangle"></i> Confirmation.!</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3><?php echo app('translator')->get('Are you sure to delete this discuss?'); ?></h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button class="btn btn-primary ml-10" type="submit"><?php echo app('translator')->get('Yes Delete'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('plugin-script'); ?>
    <script src="<?php echo e(asset('backend/plugins/lightbox/js/lightbox.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.25/webcam.min.js"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).on('click', '.deleteButton', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '<?php echo e(route('projects.discussions.delete', ':id')); ?>';
            $("#deleteForm").attr("action", url.replace(':id', id));
        })

        $('.live_capture').on('click', function(e) {
            e.preventDefault();
            

            $('#closeModal').modal('show');
        })

        $('.closeModal').on('click', function(e) {
            e.preventDefault();
            Webcam.reset();
            $('#closeModal').modal('hide')
        });

        function take_snapshot() {
            Webcam.snap(function(data_uri) {
                $(".capture_image").val(data_uri);
                Webcam.freeze();
            });
        }

        function retake_snapshot() {
            Webcam.unfreeze();
        }
    </script>
    <script>
        var loadFile = function(event) {
            var reader = new FileReader();
            reader.onload = function() {
                var output = document.getElementById('output');
                output.src = reader.result;
            };
            reader.readAsDataURL(event.target.files[0]);
        };
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aitul008/public_html/attendance/resources/views/backend/project/show.blade.php ENDPATH**/ ?>