<!DOCTYPE html>
<html>

<head>
    <title>Generate PDF Laravel 9 - NiceSnippets.com</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
</head>

<body>
    <div class="container">
        <?php if($projects->count()): ?>
            <div class="text-center">
                <h3><?php echo app('translator')->get('Date Start'); ?>: <?php echo e($startDate); ?></h3>
                <h3><?php echo app('translator')->get('Date End'); ?>: <?php echo e($endDate); ?></h3>
                <h3><?php echo app('translator')->get('Employee'); ?>: <?php echo e($semployee->count() ? $semployee->name : __('All Employee')); ?></h3>
                <h3><?php echo app('translator')->get('Customer'); ?>: <?php echo e($scustomer->count() ? $scustomer->name : __('All Customer')); ?></h3>
            </div>
        <?php endif; ?>
        <table class="table table-bordered table-stripe p-3" style="max-width: 100%">
            <thead>
                <tr>
                    <th width="10%"><?php echo app('translator')->get('SL'); ?></th>
                    <th><?php echo app('translator')->get('Customer Information'); ?></th>
                    <th><?php echo app('translator')->get('Project Code'); ?></th>
                    <th><?php echo app('translator')->get('Employee Information'); ?></th>
                    <th><?php echo app('translator')->get('Start Date'); ?></th>
                    <th><?php echo app('translator')->get('End Date'); ?></th>
                    <th><?php echo app('translator')->get('Stating Quantity'); ?></th>
                    <th><?php echo app('translator')->get('Final Quantity'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e(++$key); ?></td>
                        <td><?php echo e($project->customer->name); ?></td>
                        <td><?php echo e($project->code); ?></td>
                        <td><?php echo e($project->employee->name); ?> <br> <?php echo e($project->employee->email); ?></td>
                        <td><?php echo e($project->start_date->toDateTimeString()); ?> </td>
                        <td><?php echo e($project->end_date ? $project->end_date->toDateTimeString() : 'N/A'); ?></td>
                        <td><?php echo e($project->start_qty); ?> </td>
                        <td><?php echo e($project->final_qty ? $project->final_qty : 'N/A'); ?></td>
                        <td>
                            <?php if($project->status == 1): ?>
                                <span class="badge badge-success m-2"><?php echo e(__('Closed')); ?></span>
                            <?php else: ?>
                                <span class="badge badge-primary m-2"><?php echo e(__('Opened')); ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="100%" class="text-center"><?php echo app('translator')->get('No Project Found'); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>

</html>
<?php /**PATH /home/azaasxqn/public_html/attendance/resources/views/backend/dashboard/report-pdf.blade.php ENDPATH**/ ?>