<?php $__env->startSection('content'); ?>
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <h4><?php echo e($page_title); ?></h4>
                            <form action="<?php echo e(route('projects.index')); ?>" method="get">
                                <input type="search" name="keyword" class="p-10 rounded" value="<?php echo e(request()->keyword ?? ''); ?>" placeholder="<?php echo app('translator')->get('Search Project'); ?>">
                            </form>
                        </div>
                        <div class="card-body">
                            <div class="table-responsived">
                                <table class="table table-bordered table-stripe">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('SL'); ?></th>
                                            <th><?php echo app('translator')->get('Customer Information'); ?></th>
                                            <th><?php echo app('translator')->get('Project Code'); ?></th>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                <th><?php echo app('translator')->get('Employee Information'); ?></th>
                                            <?php endif; ?>
                                            <th><?php echo app('translator')->get('Start Date'); ?></th>
                                            
                                            <th><?php echo app('translator')->get('End Date'); ?></th>
                                            
                                            <th><?php echo app('translator')->get('Stating Quantity'); ?></th>
                                            <th><?php echo app('translator')->get('Final Quantity'); ?></th>
                                            <th><?php echo app('translator')->get('Status'); ?></th>
                                            <th><?php echo app('translator')->get('Action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($projects->total() - (--$key + $projects->firstItem())); ?></td>
                                                <td><?php echo e($project->customer->name); ?></td>
                                                <td><?php echo e($project->code); ?></td>
                                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                    <td><?php echo e($project->employee->name); ?> <br> <?php echo e($project->employee->email); ?></td>
                                                <?php endif; ?>
                                                <td>
                                                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                        <?php echo e($project->start_date->toDateTimeString()); ?>

                                                    <?php else: ?>
                                                        <?php echo e($project->start_date->toDateString()); ?>

                                                    <?php endif; ?>
                                                </td>
                                                
                                                <td>
                                                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                        <?php echo e($project->end_date ? $project->end_date->toDateTimeString() : 'N/A'); ?>

                                                    <?php else: ?>
                                                        <?php echo e($project->end_date ? $project->end_date->toDateString() : 'N/A'); ?>

                                                    <?php endif; ?>
                                                </td>
                                                
                                                <td><?php echo e($project->start_qty); ?> </td>
                                                <td><?php echo e($project->final_qty ? $project->final_qty : 'N/A'); ?></td>
                                                <td>
                                                    <?php if($project->status == 1): ?>
                                                        <span class="badge badge-success m-2"><?php echo e(__('Closed')); ?></span>
                                                    <?php else: ?>
                                                        <span class="badge badge-primary m-2"><?php echo e(__('Opened')); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-lg">
                                                        <a href="<?php echo e(route('projects.show', $project->id)); ?>" class="btn btn-outline-success" role="button" title="<?php echo app('translator')->get('View'); ?>"><i class="fa fa-eye"></i></a>
                                                        <?php if(auth()->user()->hasRole('Employee') && $project->end_date == null): ?>
                                                            <a href="<?php echo e(route('projects.edit', $project->id)); ?>" class="btn btn-outline-primary" title="<?php echo app('translator')->get('Edit'); ?>"><i class="fa fa-edit"></i></a>
                                                        <?php endif; ?>
                                                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                            <a href="<?php echo e(route('projects.edit', $project->id)); ?>" class="btn btn-outline-primary" title="<?php echo app('translator')->get('Edit'); ?>"><i class="fa fa-edit"></i></a>
                                                            <button type="button" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="<?php echo e($project->id); ?>" class="btn btn-outline-danger deleteButton" type="button" title="<?php echo app('translator')->get('Delete'); ?>"><i class="fa fa-trash"></i></button>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="100%" class="text-center"><?php echo app('translator')->get('No Project Found'); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                                <?php if($projects->hasPages()): ?>
                                    <div class="pagination-wrapper mt-10">
                                        <?php echo $projects->links(); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" method="post" id="deleteForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i class="fa fa-exclamation-triangle"></i> Confirmation.!</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3><?php echo app('translator')->get('Are you sure to delete this project?'); ?></h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button class="btn btn-primary ml-10" type="submit"><?php echo app('translator')->get('Yes Delete'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).on('click', '.deleteButton', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '<?php echo e(route('projects.destroy', ':id')); ?>';
            $("#deleteForm").attr("action", url.replace(':id', id));
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aitul008/public_html/attendance/resources/views/backend/project/index.blade.php ENDPATH**/ ?>