<?php $__env->startSection('plugin-style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2/css/select2-bootstrap-5-theme.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo e($page_title); ?></h4>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('report.index')); ?>" method="get">

                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="customer" class="form-label"><?php echo app('translator')->get('Select Customer'); ?></label>
                                    <select name="customer" id="customer" class="form-control select2">
                                        <option value="0"><?php echo app('translator')->get('All Customer'); ?></option>
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($customer->id); ?>" <?php if(request()->customer == $customer->id): echo 'selected'; endif; ?>><?php echo e($customer->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['customer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="employee" class="form-label"><?php echo app('translator')->get('Select Employee'); ?></label>
                                    <select name="employee" id="employee" class="form-control select2">
                                        <option value="0"><?php echo app('translator')->get('All Employee'); ?></option>
                                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($employee->id); ?>" <?php if(request()->employee == $employee->id): echo 'selected'; endif; ?>>
                                                <?php echo e($employee->name); ?> -- <?php echo e($employee->email); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['employee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="status" class="form-label"><?php echo app('translator')->get('Select Status'); ?></label>
                                    <select name="status" id="status" class="form-control select2">
                                        <option value=""><?php echo app('translator')->get('All Status'); ?></option>
                                        <option value="0" <?php if(request()->status == '0'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Opened'); ?></option>
                                        <option value="1" <?php if(request()->status == '1'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Closed'); ?></option>
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="daterange" class="form-label"><?php echo app('translator')->get('Select Date Range'); ?></label>
                                    <input type="text" name="daterange" readonly id="daterange"
                                           value="<?php echo e(request()->daterange ?? ''); ?>"
                                           placeholder="<?php echo app('translator')->get('Select Date Range'); ?>"
                                           class="form-control <?php $__errorArgs = ['daterange'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <?php $__errorArgs = ['daterange'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <button class="btn btn-primary btn-block" style="width: 100%" type="submit"><i
                                   class="fa fa-filter"></i> <?php echo app('translator')->get('Filter Now'); ?></button>
                        </form>
                        <hr>
                        <?php if($projects->count()): ?>
                            <div class="text-center">
                                <h3><?php echo app('translator')->get('Date Start'); ?>: <?php echo e($startDate); ?></h3>
                                <h3><?php echo app('translator')->get('Date End'); ?>: <?php echo e($endDate); ?></h3>
                                <h3><?php echo app('translator')->get('Employee'); ?>
                                    : <?php echo e($semployee->count() ? $semployee->name : __('All Employee')); ?></h3>
                                <h3><?php echo app('translator')->get('Customer'); ?>
                                    : <?php echo e($scustomer->count() ? $scustomer->name : __('All Customer')); ?></h3>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-6">
                                    <form action="<?php echo e(route('report.pdf')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="startDate" value="<?php echo e($startDate); ?>">
                                        <input type="hidden" name="endDate" value="<?php echo e($endDate); ?>">
                                        <input type="hidden" name="employee" value="<?php echo e(request()->employee); ?>">
                                        <input type="hidden" name="customer" value="<?php echo e(request()->customer); ?>">
                                        <input type="hidden" name="status" value="<?php echo e(request()->status); ?>">
                                        <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fa fa-file-pdf-o"></i> <?php echo app('translator')->get('Export as PDF'); ?></button>
                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-danger deleteButton" type="button"
                                            data-bs-toggle="modal" data-bs-target="#deleteModal" style="width: 100%;"><i
                                           class="fa fa-trash"></i> <?php echo app('translator')->get('Clear All Data'); ?></button>
                                </div>
                            </div>
                            <hr>
                        <?php endif; ?>
                        <table class="table table-bordered table-stripe">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('SL'); ?></th>
                                    <th><?php echo app('translator')->get('Customer Information'); ?></th>
                                    <th><?php echo app('translator')->get('Project Code'); ?></th>
                                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                        <th><?php echo app('translator')->get('Employee Information'); ?></th>
                                    <?php endif; ?>
                                    <th><?php echo app('translator')->get('Start Date'); ?></th>
                                    
                                    <th><?php echo app('translator')->get('End Date'); ?></th>
                                    
                                    <th><?php echo app('translator')->get('Stating Quantity'); ?></th>
                                    <th><?php echo app('translator')->get('Final Quantity'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($projects->total() - (--$key + $projects->firstItem())); ?></td>
                                        <td><?php echo e($project->customer->name); ?></td>
                                        <td><?php echo e($project->code); ?></td>
                                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                            <td><?php echo e($project->employee->name); ?> <br> <?php echo e($project->employee->email); ?></td>
                                        <?php endif; ?>
                                        <td>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                <?php echo e($project->start_date->toDateTimeString()); ?>

                                            <?php else: ?>
                                                <?php echo e($project->start_date->toDateString()); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                <?php echo e($project->end_date ? $project->end_date->toDateTimeString() : 'N/A'); ?>

                                            <?php else: ?>
                                                <?php echo e($project->end_date ? $project->end_date->toDateString() : 'N/A'); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($project->start_qty); ?> </td>
                                        <td><?php echo e($project->final_qty ?: 'N/A'); ?></td>
                                        <td>
                                            <?php if($project->status == 1): ?>
                                                <span class="badge badge-success m-2"><?php echo e(__('Closed')); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-primary m-2"><?php echo e(__('Opened')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-lg">
                                                <a href="<?php echo e(route('projects.show', $project->id)); ?>"
                                                   class="btn btn-outline-success" role="button" title="<?php echo app('translator')->get('View'); ?>"><i
                                                       class="fa fa-eye"></i></a>
                                                <?php if(auth()->user()->hasRole('Employee') && $project->end_date == null): ?>
                                                    <a href="<?php echo e(route('projects.edit', $project->id)); ?>"
                                                       class="btn btn-outline-primary" title="<?php echo app('translator')->get('Edit'); ?>"><i
                                                           class="fa fa-edit"></i></a>
                                                <?php endif; ?>
                                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                    <a href="<?php echo e(route('projects.edit', $project->id)); ?>"
                                                       class="btn btn-outline-primary" title="<?php echo app('translator')->get('Edit'); ?>"><i
                                                           class="fa fa-edit"></i></a>
                                                    <button type="button" data-bs-toggle="modal" data-bs-target="#deleteModal"
                                                            data-id="<?php echo e($project->id); ?>"
                                                            class="btn btn-outline-danger deleteButton" type="button"
                                                            title="<?php echo app('translator')->get('Delete'); ?>"><i class="fa fa-trash"></i></button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%" class="text-center"><?php echo app('translator')->get('No Project Found'); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php if($projects->isNotEmpty()): ?>
                            <?php if($projects->hasPages()): ?>
                                <div class="pagination-wrapper mt-10">
                                    <?php echo $projects->withQueryString()->links(); ?>

                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
         aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="<?php echo e(route('report.delete')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <?php if($projects->count()): ?>
                    <input type="hidden" name="startDate" value="<?php echo e($startDate); ?>">
                    <input type="hidden" name="endDate" value="<?php echo e($endDate); ?>">
                    <input type="hidden" name="employee" value="<?php echo e(request()->employee); ?>">
                    <input type="hidden" name="customer" value="<?php echo e(request()->customer); ?>">
                <?php endif; ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i
                               class="fa fa-exclamation-triangle"></i> <?php echo app('translator')->get('Confirmation'); ?></h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3><?php echo app('translator')->get('Are you sure to delete this report data?'); ?></h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button class="btn btn-primary ml-10" type="submit"><?php echo app('translator')->get('Yes Delete'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('plugin-script'); ?>
    <script src="<?php echo e(asset('backend/plugins/select2/js/select2.min.js')); ?>"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'bootstrap-5'
            });
            $('input[name="daterange"]').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'Y-MM-DD',
                    "separator": " -- ",
                }
            });
            $('input[name="daterange"]').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' -- ' + picker.endDate.format('YYYY-MM-DD'));
            });

            $('input[name="daterange"]').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/azaasxqn/public_html/attendance/resources/views/backend/dashboard/report.blade.php ENDPATH**/ ?>