<!DOCTYPE html>
<html>

<head>
    <title>Foker Engineering</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <style>
        .page-break {
            page-break-after: always
        }
    </style>
</head>

<body>
    <div class="container">

        <div class="text-center mt-2">
            <h2><?php echo e(config('app.name')); ?></h2>
        </div>
        <hr>
        <table class="table table-bordered table-stripe">
            <thead>
                <tr>
                    <th width="30%" class="text-end"><?php echo app('translator')->get('Title'); ?></th>
                    <th><?php echo app('translator')->get('Information'); ?></th>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <th><?php echo app('translator')->get('Customer Information'); ?></th>
                    <td><?php echo e($project->customer->name); ?></td>
                </tr>
                <tr>
                    <th><?php echo app('translator')->get('Project Code'); ?></th>
                    <td><?php echo e($project->code); ?></td>
                </tr>
                <tr>
                    <th><?php echo app('translator')->get('Employee Information'); ?></th>
                    <td><?php echo e($project->employee->name); ?> <br> <?php echo e($project->employee->email); ?></td>
                </tr>
                <tr>
                    <th><?php echo app('translator')->get('Start Date'); ?></th>
                    <td>
                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                            <?php echo e($project->start_date->toDateTimeString()); ?>

                        <?php else: ?>
                            <?php echo e($project->start_date->toDateString()); ?>

                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th><?php echo app('translator')->get('End Date'); ?></th>
                    <td>
                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                            <?php echo e($project->end_date ? $project->end_date->toDateTimeString() : 'N/A'); ?>

                        <?php else: ?>
                            <?php echo e($project->end_date ? $project->end_date->toDateString() : 'N/A'); ?>

                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th><?php echo app('translator')->get('Stating Quantity'); ?></th>
                    <td><?php echo e($project->start_qty); ?> </td>
                </tr>
                <tr>
                    <th><?php echo app('translator')->get('Final Quantity'); ?></th>
                    <td><?php echo e($project->final_qty ? $project->final_qty : 'N/A'); ?></td>
                </tr>
                <tr>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <td>
                        <?php if($project->status == 1): ?>
                            <span class="badge badge-success m-2"><?php echo e(__('Closed')); ?></span>
                        <?php else: ?>
                            <span class="badge badge-primary m-2"><?php echo e(__('Opened')); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php if($project->attachment): ?>
        <h3><?php echo app('translator')->get('Start Photo'); ?></h3>
        <img src="<?php echo e(public_path("storage/projects/$project->attachment")); ?>" style="max-width:100%">
    <?php endif; ?>
    <div class="page-break"></div>
    <?php if($project->final_attachment): ?>
        <h3><?php echo app('translator')->get('End Photo'); ?></h3>
        <img src="<?php echo e(public_path("storage/projects/$project->final_attachment")); ?>" style="max-width:100%">
    <?php endif; ?>
</body>

</html>
<?php /**PATH /home/aitul008/public_html/attendance/resources/views/backend/project/pdf.blade.php ENDPATH**/ ?>