<?php $__env->startSection('content'); ?>
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo e($page_title); ?></h4>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('SL'); ?></th>
                                        <th><?php echo app('translator')->get('Date'); ?></th>
                                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                            <th><?php echo app('translator')->get('User'); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo app('translator')->get('Punch In'); ?></th>
                                        <th><?php echo app('translator')->get('Punch In Image'); ?></th>
                                        <th><?php echo app('translator')->get('Punch Out'); ?></th>
                                        <th><?php echo app('translator')->get('Punch Out Image'); ?></th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($key + $logs->firstItem()); ?></td>
                                            <td><?php echo e($log->attend_at->toFormattedDayDateString()); ?></td>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                                <td><?php echo e($log->user->name); ?> <br> <?php echo e($log->user->email); ?></td>
                                            <?php endif; ?>
                                            <td>
                                                <?php if($log->punch_in_at): ?>
                                                    <?php echo e($log->punch_in_at->toDayDateTimeString()); ?>

                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($log->punch_in_img): ?>
                                                    <a href="<?php echo e(route('attend.punch-in.download', $log->id)); ?>" class="badge badge-success"><?php echo app('translator')->get('Download'); ?></a>
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($log->punch_out_at): ?>
                                                    <?php echo e($log->punch_out_at->toDayDateTimeString()); ?>

                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($log->punch_out_img): ?>
                                                    <a href="<?php echo e(route('attend.punch-out.download', $log->id)); ?>" class="badge badge-success"><?php echo app('translator')->get('Download'); ?></a>
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="100%" class="text-center"><?php echo app('translator')->get('No Attendance Found.'); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <?php if($logs->hasPages()): ?>
                                <div class="pagination-wrapper mt-10">
                                    <?php echo $logs->links(); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aitul008/public_html/attendance/resources/views/backend/attendance/index.blade.php ENDPATH**/ ?>