<?php

namespace App\Http\Controllers\Backend;

use App\Models\Attendance;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Intervention\Image\Facades\Image;
use RealRashid\SweetAlert\Facades\Alert;

class AttendanceController extends Controller
{

    public function index()
    {
        $data['page_title'] = __('Attendance List');
        $user = Auth::user();
        $data['logs'] = Attendance::with('user')
            ->when($user->hasRole('Employee'), function ($q) {
                $q->where('user_id', Auth::id());
            })
            ->orderByDesc('id')
            ->paginate();

        return view('backend.attendance.index', $data);
    }

    /**
     * @param Request $request
     */
    public function submit(Request $request)
    {
        $request->validate([
            'punch_image' => 'required',
        ]);

        $fileName = null;
        if ($request->filled('punch_image')) {
            $file = $request->punch_image;
            $ext = explode('/', substr($file, 0, strpos($file, ';')))[1];
            $fileName = date('Y-m-d H:i:s') . '-' . random_int(1111, 9999) . '.' . $ext;
            Image::make($file)->encode('webp')->save(public_path("storage/attendances/{$fileName}"));
        }
        $attend = Attendance::whereDate('attend_at', today())->whereUserId(Auth::id())->first();

        if ($attend) {
            $attend->update([
                'punch_out_at'  => now(),
                'punch_out_img' => $fileName,
            ]);
            $message = __('Punch Out Successfully Completed.');
        } else {
            Attendance::create([
                'attend_at'    => today(),
                'user_id'      => Auth::id(),
                'punch_in_at'  => now(),
                'punch_in_img' => $fileName,
            ]);
            $message = __('Punch In Successfully Completed.');
        }

        Alert::success(__('Congratulation'), $message);
        return redirect()->back();
    }

    /**
     * @param $id
     */
    public function punchInDownload($id)
    {
        $attend = Attendance::findOrFail($id);
        $file = public_path("storage/attendances/$attend->punch_in_img");
        return response()->download($file);
    }

    /**
     * @param $id
     */
    public function punchOutDownload($id)
    {
        $attend = Attendance::findOrFail($id);
        $file = public_path("storage/attendances/$attend->punch_out_img");
        return response()->download($file);
    }
}
