<?php

namespace App\Http\Controllers\Chart;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Models\Attendance;

class Last30DaysChart
{
    /**
     * @return mixed
     */
    public function generate()
    {
        $query = Attendance::query();
        $query->where('created_at', '>=', now()->subDays(30)->format('Y-m-d'));
        $collection = $query->get();
        $chartQuery = $collection->sortBy('created_at')
            ->groupBy(function ($entry) {
                return $entry->created_at->format('Y-m-d');
            })
            ->map(function ($entries) {
                return $entries->count();
            });
        $cDate = [];
        $cData = [];
        CarbonPeriod::since(now()->subDays(30))
            ->until(now())
            ->forEach(function (Carbon $date) use ($chartQuery, &$cData, &$cDate) {
                $key = $date->format('Y-m-d');
                $cDate[] = $key;
                $cData[] = $chartQuery[$key] ?? 0;
            });

        return [$cDate, $cData];
        /* $chartQuery = $newData;

        $newData = collect([]);
        $format = 'Y-m-d';
        CarbonPeriod::since(now()->subDays(30))
        ->until(now())
        ->forEach(function (Carbon $date) use (&$newData, $format) {
        $key = $date->format($format);
        $newData->put($key, 0);
        });
        dd($chartQuery); */
        return $chartQuery;

        /* $line = new LineChart();
    $line->setLabels($chartQuery->keys());
    $line->setSeries([
    [
    'label' => 'Signal',
    'data'  => $chartQuery->values()->toArray(),
    ],
    ]);
     */

    }
}
