<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Attendance extends Model
{
    use HasFactory;

    /**
     * @var array
     */
    protected $fillable = [
        'attend_at',
        'user_id',
        'punch_in_at',
        'punch_in_img',
        'punch_out_at',
        'punch_out_img',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'attend_at'    => 'date',
        'punch_in_at'  => 'datetime',
        'punch_out_at' => 'datetime',
    ];

    /**
     * Get the user that owns the Attendance
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
