@extends('layouts.backend.auth')

@section('content')
    <!-- Forgot password start-->
    <div class="auth-main">
        <div class="codex-authbox">
            <div class="auth-header">
                <div class="codex-brand">
                    <a href="{{ url('/') }}">
                        <img class="img-fluid light-logo" src="{{ asset('backend/images/logo/dark-logo.png') }}" alt="">
                        <img class="img-fluid dark-logo" src="{{ asset('backend/images/logo/logo.png') }}" alt="">
                    </a>
                </div>
                <h3>forgot password ? </h3>
                <p>@lang('Enter Your Email address And We will Send You A reset Link.')</p>
            </div>
            @if (session('status'))
                <div class="alert alert-success" role="alert">
                    {{ session('status') }}
                </div>
            @endif
            <form method="POST" action="{{ route('password.email') }}">
                @csrf
                <div class="form-group mb-0">
                    <label class="form-label" for="email">{{ __('Email Address') }}</label>
                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required placeholder="{{ __('Email Address') }}" autocomplete="email" autofocus>
                    @error('email')
                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                    @enderror
                </div>
                <div class="form-group mb-0">
                    <button class="btn btn-primary" type="submit"><i class="fa fa-key"></i> @lang('Send Reset Link')</button>
                </div>
            </form>
        </div>
    </div>
    <!-- Forgot password end-->
@endsection
