@extends('layouts.backend.auth')

@section('content')
    <section class="py-100">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="codex-authbox">
                        <div class="auth-header">
                            <div class="codex-brand">
                                <a href="{{ url('/') }}">
                                    <img class="img-fluid light-logo" src="{{ asset('backend/images/logo/dark-logo.png') }}" alt="">
                                    <img class="img-fluid dark-logo" src="{{ asset('backend/images/logo/logo.png') }}" alt="">
                                </a>
                            </div>
                            <h3>Create your account</h3>
                            <h6>Already have an account? <a class="text-primary" href="{{ route('login') }}">login in here</a></h6>
                        </div>
                        <form method="POST" action="{{ route('register') }}">
                            @csrf
                            <div class="form-group">
                                <label class="form-label">{{ __('Name') }}</label>
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" placeholder="{{ __('Name') }}" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>
                                @error('name')
                                    <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label class="form-label">{{ __('Email Address') }}</label>
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" placeholder="{{ __('Email Address') }}" value="{{ old('email') }}" required autocomplete="email">
                                @error('email')
                                    <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label class="form-label" for="Password">{{ __('Password') }}</label>
                                <div class="input-group group-input">
                                    <input class="form-control showhide-password @error('password') is-invalid @enderror" id="password" name="password" type="password" placeholder="{{ __('Password') }}" required autocomplete="new-password"><span class="input-group-text toggle-show fa fa-eye"></span>
                                    @error('password')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="form-label" for="Password-confirm">{{ __('Confirm Password') }}</label>
                                <div class="input-group group-input">
                                    <input class="form-control showhide-password2" id="Password-confirm" name="password_confirmation" type="password" placeholder="{{ __('Confirm Password') }}" required autocomplete="new-password">
                                    <span class="input-group-text toggle-show2 fa fa-eye"></span>
                                </div>
                            </div>
                            <div class="form-group mb-0">
                                <div class="auth-remember">
                                    <div class="form-check custom-chek">
                                        <input class="form-check-input" id="agree" type="checkbox" value="" required="">
                                        <label class="form-check-label" for="agree">I Agree Terms and conditions</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-paper-plane"></i> {{ __('Register') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
