@extends('layouts.backend.auth')

@section('content')
    <!-- Verify Email Start-->
    <div class="auth-main">
        <div class="codex-authbox">
            <div class="auth-header">
                <div class="auth-icon"> <i class="fa fa-envelope"></i></div>
                <h3>{{ __('Verify Your Email Address') }}</h3>
                <p class="text-lowercase pt-2">@lang('Please check your email inbox or spam box there have an activation link') <br> @lang('Click this link to verify this email address.')</p>
            </div>
            @if (session('status') || session('resend'))
                <div class="alert alert-success" role="alert">
                    {{ __('A fresh verification link has been sent to your email address.') }}
                </div>
            @endif
            <form class="d-inline" method="POST" action="{{ route('verification.send') }}">
                @csrf
                <div class="form-group mb-0">
                    <button class="btn btn-primary" type="submit">{{ __('Click here to request another') }}</button>
                </div>
            </form>
        </div>
    </div>
    <!-- Verify Email End-->
@endsection
