@extends('layouts.backend.master')

@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ $page_title }}</h4>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>@lang('SL')</th>
                                        <th>@lang('Date')</th>
                                        @role('Super Admin')
                                            <th>@lang('User')</th>
                                        @endrole
                                        <th>@lang('Punch In')</th>
                                        <th>@lang('Punch In Image')</th>
                                        <th>@lang('Punch Out')</th>
                                        <th>@lang('Punch Out Image')</th>
                                        {{--  <th>@lang('Action')</th>  --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($logs as $key => $log)
                                        <tr>
                                            <td>{{ $key + $logs->firstItem() }}</td>
                                            <td>{{ $log->attend_at->toFormattedDayDateString() }}</td>
                                            @role('Super Admin')
                                                <td>{{ $log->user->name }} <br> {{ $log->user->email }}</td>
                                            @endrole
                                            <td>
                                                @if ($log->punch_in_at)
                                                    {{ $log->punch_in_at->toDayDateTimeString() }}
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td>
                                                @if ($log->punch_in_img)
                                                    <a href="{{ route('attend.punch-in.download', $log->id) }}" class="badge badge-success">@lang('Download')</a>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td>
                                                @if ($log->punch_out_at)
                                                    {{ $log->punch_out_at->toDayDateTimeString() }}
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td>
                                                @if ($log->punch_out_img)
                                                    <a href="{{ route('attend.punch-out.download', $log->id) }}" class="badge badge-success">@lang('Download')</a>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="100%" class="text-center">@lang('No Attendance Found.')</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                            @if ($logs->hasPages())
                                <div class="pagination-wrapper mt-10">
                                    {!! $logs->links() !!}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
