@extends('layouts.backend.master')

@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>@lang('Create Customer')</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('customers.store') }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <label for="name" class="form-label">@lang('Customer Name')</label>
                                    <input type="text" name="name" id="name" value="{{ old('name') }}" placeholder="@lang('Customer Name')" class="form-control @error('name') is-invalid @enderror" required>
                                    @error('name')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>
                                <button class="btn btn-primary" type="submit"><i class="fa fa-user-plus"></i> @lang('Create Customer')</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
