@extends('layouts.backend.master')
@section('plugin-style')
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2/css/select2-bootstrap-5-theme.min.css') }}">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection
@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                @php $attMama = config('services.attendance') == 'enabled' ? true : false @endphp
                @if ($attMama)
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                @if (!$attend)
                                    <h4 class="text-danger mb-10">{{ __('No Shift Today') }}</h4>
                                @else
                                    <h4 class="text-danger mb-10">{{ __('Today Attend Time') }}</h4>
                                    @if ($attend->punch_in_at)
                                        <h4 class="text-primary mb-10">@lang('Punch In'): {{ $attend->punch_in_at->toDayDateTimeString() }}</h4>
                                    @endif
                                    @if ($attend->punch_out_at)
                                        <h4 class="text-danger mb-10">@lang('Punch Out'): {{ $attend->punch_out_at->toDayDateTimeString() }}</h4>
                                    @endif
                                @endif
                            </div>

                            <div class="card-body">
                                <form method="post" action="{{ route('attend.submit') }}" enctype="multipart/form-data" id="punchForm">
                                    @csrf
                                    <input type="hidden" value="" id="punch_image" name="punch_image">
                                    @if ($attend)
                                        @if ($attend->punch_out_at == null)
                                            <button type="button" class="btn btn-primary btn-lg punchModal">@lang('Click here to Punch Out')</button>
                                        @endif
                                    @else
                                        <button type="button" class="btn btn-success btn-lg punchModal">@lang('Click here to Punch In')</button>
                                    @endif
                                </form>
                            </div>
                        </div>
                    </div>
                @endif
                @role('Super Admin')
                    <div class="col-md-{{ $attMama ? '4' : '6' }}">
                        <div class="card">
                            <div class="card-header">
                                <h4>@lang('Total Project')</h4>
                            </div>
                            <div class="card-body">
                                <h2>{{ $totalProject }} @lang('Projects')</h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-{{ $attMama ? '4' : '6' }}">
                        <div class="card">
                            <div class="card-header">
                                <h4>@lang('Total Employee')</h4>
                            </div>
                            <div class="card-body">
                                <h2>{{ $totalEmployee }} s</h2>
                            </div>
                        </div>
                    </div>
                @endrole
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ trans('Filter') }}</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('dashboard') }}" method="get">
                                <div class="row">

                                    @role('Employee')
                                        <div class="form-group col-md-12">
                                            <label for="customer" class="form-label">@lang('Select Customer')</label>
                                            <select name="customer" id="customer" class="form-control select2">
                                                <option value="0">@lang('All Customer')</option>
                                                @foreach ($customers as $customer)
                                                    <option value="{{ $customer->id }}" @selected(request()->customer == $customer->id)>{{ $customer->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('customer')
                                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                            @enderror
                                        </div>
                                    @endrole
                                    @role('Super Admin')
                                        <div class="form-group col-md-6">
                                            <label for="customer" class="form-label">@lang('Select Customer')</label>
                                            <select name="customer" id="customer" class="form-control select2">
                                                <option value="0">@lang('All Customer')</option>
                                                @foreach ($customers as $customer)
                                                    <option value="{{ $customer->id }}" @selected(request()->customer == $customer->id)>{{ $customer->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('customer')
                                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                            @enderror
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="employee" class="form-label">@lang('Select Employee')</label>
                                            <select name="employee" id="employee" class="form-control select2">
                                                <option value="0">@lang('All Employee')</option>
                                                @foreach ($employees as $employee)
                                                    <option value="{{ $employee->id }}" @selected(request()->employee == $employee->id)>{{ $employee->name }} -- {{ $employee->email }}</option>
                                                @endforeach
                                            </select>
                                            @error('employee')
                                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                            @enderror
                                        </div>
                                    @endrole
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label for="status" class="form-label">@lang('Select Status')</label>
                                        <select name="status" id="status" class="form-control select2">
                                            <option value="">@lang('All Status')</option>
                                            <option value="0" @selected(request()->status == '0')>@lang('Opened')</option>
                                            <option value="1" @selected(request()->status == '1')>@lang('Closed')</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="daterange" class="form-label">@lang('Select Date Range')</label>
                                        <input type="text" name="daterange" readonly id="daterange" value="{{ request()->daterange ?? '' }}" placeholder="@lang('Select Date Range')" class="form-control @error('daterange') is-invalid @enderror" required>
                                        @error('daterange')
                                            <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>

                                <button class="btn btn-primary btn-block" style="width: 100%" type="submit"><i class="fa fa-filter"></i> @lang('Filter Now')</button>
                            </form>
                            <hr>
                            {{--  <h3 class="my-20">{{ $subTitle }}</h3>  --}}
                            <table class="table table-bordered table-stripe">
                                <thead>
                                    <tr>
                                        <th>@lang('SL')</th>
                                        <th>@lang('Customer Information')</th>
                                        <th>@lang('Project Code')</th>
                                        @role('Super Admin')
                                            <th>@lang('Employee Information')</th>
                                        @endrole
                                        <th>@lang('Start Date')</th>
                                        <th>@lang('End Date')</th>
                                        <th>@lang('Stating Quantity')</th>
                                        <th>@lang('Final Quantity')</th>
                                        <th>@lang('Status')</th>
                                        <th>@lang('Action')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($projects as $key => $project)
                                        <tr>
                                            <td>{{ $projects->total() - (--$key + $projects->firstItem()) }}</td>
                                            <td>{{ $project->customer->name }}</td>
                                            <td>{{ $project->code }}</td>
                                            @role('Super Admin')
                                                <td>{{ $project->employee->name }} <br> {{ $project->employee->email }}</td>
                                            @endrole
                                            <td>
                                                @role('Super Admin')
                                                    {{ $project->start_date->toDateTimeString() }}
                                                @else
                                                    {{ $project->start_date->toDateString() }}
                                                @endrole
                                            </td>
                                            <td>
                                                @role('Super Admin')
                                                    {{ $project->end_date ? $project->end_date->toDateTimeString() : 'N/A' }}
                                                @else
                                                    {{ $project->end_date ? $project->end_date->toDateString() : 'N/A' }}
                                                @endrole
                                            </td>
                                            <td>{{ $project->start_qty }} </td>
                                            <td>{{ $project->final_qty ? $project->final_qty : 'N/A' }}</td>
                                            <td>
                                                @if ($project->status == 1)
                                                    <span class="badge badge-success m-2">{{ __('Closed') }}</span>
                                                @else
                                                    <span class="badge badge-primary m-2">{{ __('Opened') }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-lg">
                                                    <a href="{{ route('projects.show', $project->id) }}" class="btn btn-outline-success" role="button" title="@lang('View')"><i class="fa fa-eye"></i></a>
                                                    @if (auth()->user()->hasRole('Employee') && $project->end_date == null)
                                                        <a href="{{ route('projects.edit', $project->id) }}" class="btn btn-outline-primary" title="@lang('Edit')"><i class="fa fa-edit"></i></a>
                                                    @endif
                                                    @role('Super Admin')
                                                        <a href="{{ route('projects.edit', $project->id) }}" class="btn btn-outline-primary" title="@lang('Edit')"><i class="fa fa-edit"></i></a>
                                                        <button type="button" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="{{ $project->id }}" class="btn btn-outline-danger deleteButton" type="button" title="@lang('Delete')"><i class="fa fa-trash"></i></button>
                                                    @endrole
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="100%" class="text-center">@lang('No Project Found')</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                            @if ($projects->isNotEmpty())
                                @if ($projects->hasPages())
                                    <div class="pagination-wrapper mt-10">
                                        {!! $projects->withQueryString()->links() !!}
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Camera Modal -->
    <div class="modal fade" id="punchModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="punchModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="punchModalLongTitle">@lang('Take a snapshot')</h5>
                    <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="fa fa-times"></i></a>
                </div>
                <div class="modal-body">
                    <div id="my_camera"></div>
                    <br />
                    <button type="button" class="btn btn-primary ml-1" onClick="take_snapshot()"><i class="fa fa-camera"></i> @lang('Take Snapshot')</button>
                    <button type="button" class="btn btn-danger ml-1" onClick="retake_snapshot()"><i class="fa fa-repeat"></i> @lang('Retake Snapshot')</button>
                    <input type="hidden" name="image" class="image-tag">
                    {{--  <input type="file" name="customFile" id="customFile" class="form-control mt-10">  --}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary closePunchModal">@lang('Close')</button>
                    <button type="button" class="btn btn-primary mainTitle" disabled>@lang('Save Attend')</button>
                </div>
            </div>
        </div>
    </div>
    {{--  Discuss delete modal  --}}
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" method="post" id="deleteForm">
                @csrf
                @method('DELETE')
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i class="fa fa-exclamation-triangle"></i> Confirmation.!</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3>@lang('Are you sure to delete this project?')</h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">@lang('Close')</button>
                        <button class="btn btn-primary ml-10" type="submit">@lang('Yes Delete')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('plugin-script')
    <script src="{{ asset('backend/plugins/select2/js/select2.min.js') }}"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
@endsection
@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.25/webcam.min.js"></script>
    <script language="JavaScript">
        $('.punchModal').on('click', function(e) {
            e.preventDefault();
            Webcam.set({
                width: 470,
                height: 340,
                image_format: 'jpeg',
                jpeg_quality: 90,
                flip_horiz: true
            });
            Webcam.attach('#my_camera');
            $('#punchModal').modal('show');
            $('.mainTitle').text($(this).data('text'));
        });

        $('.closePunchModal').on('click', function(e) {
            e.preventDefault();
            Webcam.reset();
            $('#punchModal').modal('hide')
        });

        function take_snapshot() {
            Webcam.snap(function(data_uri) {
                $("#punch_image").val(data_uri);
                $('.mainTitle').attr('disabled', false);
                Webcam.freeze();
            });
        }

        function retake_snapshot() {
            $('.mainTitle').attr('disabled', true);
            Webcam.unfreeze();
        }

        $('.mainTitle').on('click', function(e) {
            e.preventDefault();
            document.getElementById("punchForm").submit();
        })
    </script>
    <script type="text/javascript">
        $(document).on('click', '.deleteButton', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '{{ route('projects.destroy', ':id') }}';
            $("#deleteForm").attr("action", url.replace(':id', id));
        })
    </script>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'bootstrap-5'
            });
            $('input[name="daterange"]').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'Y-MM-DD',
                    "separator": " -- ",
                }
            });
            $('input[name="daterange"]').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' -- ' + picker.endDate.format('YYYY-MM-DD'));
            });

            $('input[name="daterange"]').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
        });
    </script>
@endsection
