@extends('layouts.backend.master')

@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>@lang('Create New Employee')</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('employees.store') }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <label for="name" class="form-label">@lang('Employee Name')</label>
                                    <input type="text" name="name" id="name" value="{{ old('name') }}" placeholder="@lang('Employee Name')" class="form-control @error('name') is-invalid @enderror" required>
                                    @error('name')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="email" class="form-label">@lang('Employee Email Address')</label>
                                    <input type="email" name="email" id="email" value="{{ old('email') }}" placeholder="@lang('Employee Email Address')" class="form-control @error('email') is-invalid @enderror" required>
                                    @error('email')
                                        <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label class="form-label" for="Password">{{ __('Password') }}</label>
                                    <div class="input-group group-input">
                                        <input class="form-control showhide-password @error('password') is-invalid @enderror" id="password" name="password" type="password" placeholder="{{ __('Password') }}" required autocomplete="new-password">
                                        <span class="input-group-text toggle-show fa fa-eye"></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="Password-confirm">{{ __('Confirm Password') }}</label>
                                    <div class="input-group group-input">
                                        <input class="form-control showhide-password2" id="Password-confirm" name="password_confirmation" type="password" placeholder="{{ __('Confirm Password') }}" required autocomplete="new-password">
                                        <span class="input-group-text toggle-show2 fa fa-eye"></span>
                                    </div>
                                </div>
                                <button class="btn btn-primary" type="submit"><i class="fa fa-user-plus"></i> @lang('Create Employee')</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
