<!DOCTYPE html>
<html>

<head>
    <title>Foker Engineering</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <style>
        .page-break {
            page-break-after: always
        }
    </style>
</head>

<body>
    <div class="container">

        <div class="text-center mt-2">
            <h2>{{ config('app.name') }}</h2>
        </div>
        <hr>
        <table class="table table-bordered table-stripe">
            <thead>
                <tr>
                    <th width="30%" class="text-end">@lang('Title')</th>
                    <th>@lang('Information')</th>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <th>@lang('Customer Information')</th>
                    <td>{{ $project->customer->name }}</td>
                </tr>
                <tr>
                    <th>@lang('Project Code')</th>
                    <td>{{ $project->code }}</td>
                </tr>
                <tr>
                    <th>@lang('Employee Information')</th>
                    <td>{{ $project->employee->name }} <br> {{ $project->employee->email }}</td>
                </tr>
                <tr>
                    <th>@lang('Start Date')</th>
                    <td>
                        @role('Super Admin')
                            {{ $project->start_date->toDateTimeString() }}
                        @else
                            {{ $project->start_date->toDateString() }}
                        @endrole
                    </td>
                </tr>
                <tr>
                    <th>@lang('End Date')</th>
                    <td>
                        @role('Super Admin')
                            {{ $project->end_date ? $project->end_date->toDateTimeString() : 'N/A' }}
                        @else
                            {{ $project->end_date ? $project->end_date->toDateString() : 'N/A' }}
                        @endrole
                    </td>
                </tr>
                <tr>
                    <th>@lang('Stating Quantity')</th>
                    <td>{{ $project->start_qty }} </td>
                </tr>
                <tr>
                    <th>@lang('Final Quantity')</th>
                    <td>{{ $project->final_qty ? $project->final_qty : 'N/A' }}</td>
                </tr>
                <tr>
                    <th>@lang('Status')</th>
                    <td>
                        @if ($project->status == 1)
                            <span class="badge badge-success m-2">{{ __('Closed') }}</span>
                        @else
                            <span class="badge badge-primary m-2">{{ __('Opened') }}</span>
                        @endif
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    @if ($project->attachment)
        <h3>@lang('Start Photo')</h3>
        <img src="{{ public_path("storage/projects/$project->attachment") }}" style="max-width:100%">
    @endif
    <div class="page-break"></div>
    @if ($project->final_attachment)
        <h3>@lang('End Photo')</h3>
        <img src="{{ public_path("storage/projects/$project->final_attachment") }}" style="max-width:100%">
    @endif
</body>

</html>
