@extends('layouts.backend.master')
@section('plugin-style')
    <link href="{{ asset('backend/plugins/lightbox/css/lightbox.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ $page_title }}</h4>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-stripe">
                                <thead>
                                    <tr>
                                        <th width="30%" class="text-end">@lang('Title')</th>
                                        <th>@lang('Information')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-end">{{ __('Project Code') }}</td>
                                        <td>{{ $project->code }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-end">{{ __('Customer Information') }}</td>
                                        <td>{{ $project->customer->name }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-end">{{ __('Start Date') }}</td>
                                        <td>
                                            @role('Super Admin')
                                                {{ $project->start_date->toDateTimeString() }}
                                            @else
                                                {{ $project->start_date->toDateString() }}
                                            @endrole
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-end">{{ __('Finish Date') }}</td>
                                        <td>
                                            @role('Super Admin')
                                                {{ $project->end_date ? $project->end_date->toDateTimeString() : 'N/A' }}
                                            @else
                                                {{ $project->end_date ? $project->end_date->toDateString() : 'N/A' }}
                                            @endrole
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-end">{{ __('Stating Quantity') }}</td>
                                        <td>{{ $project->start_qty }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-end">{{ __('Final Quantity') }}</td>
                                        <td>{{ $project->final_qty ? $project->final_qty : 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-end">{{ __('Initial Photo') }}</td>
                                        <td>

                                            @if ($project->attachment)
                                                @php $att = explode('.',$project->attachment) @endphp
                                                @if ($att[1] == 'png' || $att[1] == 'jpeg' || $att[1] == 'jpg')
                                                    <a href="{{ asset("storage/projects/$project->attachment") }}" class="badge badge-success" data-lightbox="{{ $project->code }}" data-title="{{ $project->customer->name }} - {{ $project->customer->phone }}">
                                                        <img src="{{ asset("storage/projects/$project->attachment") }}" height="100px" width="100px">
                                                    </a>
                                                @else
                                                    <p class="text-danger">@lang('This format not previewable')</p>
                                                @endif
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-end">{{ __('Notes') }}</td>
                                        <td>{{ $project->note }}</td>
                                    </tr>

                                    @if ($project->end_date)
                                        <tr>
                                            <td class="text-end">{{ __('Final Photo') }}</td>
                                            <td>
                                                <a href="{{ asset("storage/projects/$project->final_attachment") }}" class="badge badge-success" data-lightbox="{{ $project->code }}__" data-title="{{ $project->customer->name }}">
                                                    <img src="{{ asset("storage/projects/$project->final_attachment") }}" height="100px" width="100px">
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-end">{{ __('Final Note') }}</td>
                                            <td>{{ $project->final_note }}</td>
                                        </tr>
                                    @endif

                                    <tr>
                                        <td class="text-end">{{ __('Status') }}</td>
                                        <td>
                                            @if ($project->status == 1)
                                                <span class="badge badge-success m-2">{{ __('Closed') }}</span>
                                            @else
                                                <span class="badge badge-primary m-2">{{ __('Opened') }}</span>
                                            @endif
                                        </td>
                                    </tr>

                                    @if (auth()->user()->hasRole('Employee') && $project->end_date == null)
                                        <tr>
                                            <td class="text-end">{{ __('Action') }}</td>
                                            <td>
                                                <button type="button" class="btn btn-outline-success btn-md m-2 live_capture"><i class="fa fa-check"></i> {{ __('Close Project') }}</button>
                                                <a href="{{ route('projects.pdf', $project->id) }}" class="btn btn-outline-primary btn-md text-success"><i class="fa fa-file-pdf-o"></i> @lang('Export as PDF')</a>
                                                @if ($project->attachment)
                                                    <a href="{{ route('projects.download', $project->id) }}" class="btn btn-outline-success btn-md"><i class="fa fa-download"></i> @lang('Download Initial Photo')</a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endif

                                    @role('Super Admin')
                                        <tr>
                                            <td class="text-end">{{ __('Action') }}</td>
                                            <td>
                                                <button type="button" class="btn btn-outline-success btn-md m-2 live_capture"><i class="fa fa-check"></i> {{ __('Close Project') }}</button>
                                                <a href="{{ route('projects.pdf', $project->id) }}" class="btn btn-outline-primary btn-md text-success"><i class="fa fa-file-pdf-o"></i> @lang('Export as PDF')</a>
                                                @if ($project->attachment)
                                                    <a href="{{ route('projects.download', $project->id) }}" class="btn btn-outline-success btn-md"><i class="fa fa-download"></i> @lang('Download Initial Photo')</a>
                                                @endif
                                                @if ($project->final_attachment)
                                                    <a href="{{ route('projects.final-download', $project->id) }}" class="btn btn-outline-primary btn-md"><i class="fa fa-download"></i> @lang('Download Final Photo')</a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endrole
                                </tbody>
                            </table>
                            <div class="d-flex justify-content-between mt-20">
                                <h3>{{ __('Discussions') }}</h3>
                                <div class="text-left bg-transparent">
                                    <button type="button" class="btn btn-primary btn-md m-2" data-bs-toggle="modal" data-bs-target="#addNewDiscuss"><i class="fa fa-plus"></i> {{ __('Add Discussion') }}</button>
                                </div>
                            </div>

                            <div class="table-responsive mt-20">
                                <table id="ul-contact-list" class="display table p-0">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Created By') }}</th>
                                            <th>@lang('Role')</th>
                                            <th>{{ __('Message') }}</th>
                                            <th>{{ __('Attachment') }}</th>
                                            <th>{{ __('Date') }}</th>
                                            @role('Super Admin')
                                                <th>{{ __('Action') }}</th>
                                            @endrole
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($project->discussions as $discussion)
                                            <tr>
                                                <td>{{ $discussion->user->name }} <br>{{ $discussion->user->email }}</td>
                                                <td>{{ $discussion->user->getRoleNames()->first() }}</td>
                                                <td>{{ $discussion->message }}</td>
                                                <td>
                                                    @if ($discussion->attachment)
                                                        @role('Super Admin')
                                                            <a href="{{ route('projects.discussions.download', $discussion->id) }}" class="badge badge-success">@lang('Download')</a>
                                                        @endrole
                                                        @php $att = explode('.',$discussion->attachment) @endphp
                                                        @if ($att[1] == 'png' || $att[1] == 'jpeg' || $att[1] == 'jpg')
                                                            <a href="{{ asset("storage/discussions/$discussion->attachment") }}" class="badge badge-success" data-lightbox="{{ $discussion->id }}" data-title="{{ $discussion->message }}">{{ __('Preview') }}</a>
                                                        @else
                                                            <p class="text-danger">@lang('This format not previewable')</p>
                                                        @endif
                                                    @else
                                                        N/A
                                                    @endif
                                                </td>
                                                <td>{{ $discussion->created_at }}</td>
                                                @role('Super Admin')
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-danger deleteButton" data-id="{{ $discussion->id }}" data-bs-toggle="modal" data-bs-target="#deleteModal" title="Delete">
                                                            <i class="fa fa-trash"></i> @lang('Delete')
                                                        </button>
                                                    </td>
                                                @endrole
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{--  Add new Discuss modal  --}}
    <div class="modal fade" id="addNewDiscuss" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addNewDiscussLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <form action="{{ route('projects.discussions') }}" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="project_id" value="{{ $project->id }}">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addNewDiscussLabel">@lang('Add New Discuss')</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="message" class="form-label">@lang('Message'):</label>
                            <textarea name="message" id="message" rows="3" placeholder="@lang('Message')" class="form-control @error('message') is-invalid @enderror">{{ old('message') }}</textarea>
                            @error('end_date')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="attachment" class="form-label">@lang('Attachment'):</label>
                            <input type="file" name="attachment" id="attachment" placeholder="@lang('Attachment')" class="form-control @error('attachment') is-invalid @enderror">
                            @error('attachment')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">@lang('Close')</button>
                        <button class="btn btn-primary ml-10" type="submit">@lang('Save')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    {{--  Close Project modal  --}}
    <div class="modal fade" id="closeModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="closeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-xl">
            <form action="{{ route('projects.close') }}" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="project_id" value="{{ $project->id }}">
                <input type="hidden" name="capture_image" class="capture_image">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addNewDiscussLabel">@lang('Close Project')</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3 class="mb-10 text-danger">@lang('Are you sure want to close this project?')</h3>
                        <div class="form-group">
                            <label for="final_quantity" class="form-label">@lang('Final Quantity'):</label>
                            <input type="number" name="final_quantity" id="final_quantity" placeholder="@lang('Final Quantity')" value="{{ old('final_quantity') }}" class="form-control @error('final_quantity') is-invalid @enderror" required>
                            @error('final_quantity')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="attachment" class="form-label">@lang('Attachment'):</label>
                                <input type="file" name="final_attachment" id="attachment" placeholder="@lang('Attachment')" onchange="loadFile(event)" class="form-control @error('attachment') is-invalid @enderror" required>
                                @error('attachment')
                                    <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="form-group col-md-12">
                                <label for="preview" class="form-label">@lang('Preview'):</label> <br>
                                <img id="output" style="max-width:100% !important" />
                            </div>
                            {{--  <div class="form-group col-md-12">
                                <label for="live_capture" class="form-label">@lang('Live Capture'):</label> <br>
                                <div id="my_camera"></div>
                                <br />
                                <button type="button" class="btn btn-primary ml-1" onClick="take_snapshot()"><i class="fa fa-camera"></i> @lang('Take Snapshot')</button>
                                <button type="button" class="btn btn-danger ml-1" onClick="retake_snapshot()"><i class="fa fa-repeat"></i> @lang('Retake Snapshot')</button>
                            </div>  --}}
                        </div>

                        <div class="form-group">
                            <label for="final_note" class="form-label">@lang('Note'):</label>
                            <textarea name="final_note" id="final_note" rows="3" placeholder="@lang('Note')" class="form-control @error('final_note') is-invalid @enderror">{{ old('final_note') }}</textarea>
                            @error('final_note')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary closeModal" type="button">@lang('Close')</button>
                        <button class="btn btn-primary ml-10" type="submit">@lang('Save')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    {{--  Discuss delete modal  --}}
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" method="post" id="deleteForm">
                @csrf
                @method('DELETE')
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel"><i class="fa fa-exclamation-triangle"></i> Confirmation.!</h5>
                        <a href="javascript:void(0);" data-bs-dismiss="modal"><i class="ti-close"></i></a>
                    </div>
                    <div class="modal-body">
                        <h3>@lang('Are you sure to delete this discuss?')</h3>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">@lang('Close')</button>
                        <button class="btn btn-primary ml-10" type="submit">@lang('Yes Delete')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('plugin-script')
    <script src="{{ asset('backend/plugins/lightbox/js/lightbox.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.25/webcam.min.js"></script>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).on('click', '.deleteButton', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '{{ route('projects.discussions.delete', ':id') }}';
            $("#deleteForm").attr("action", url.replace(':id', id));
        })

        $('.live_capture').on('click', function(e) {
            e.preventDefault();
            {{--  Webcam.set({
                width: 800,
                height: 600,
                image_format: 'jpeg',
                jpeg_quality: 90,
                //flip_horiz: true,
                constraints: {
                    video: true,
                    facingMode: 'environment',
                    width: {
                        exact: 800
                    },
                    height: {
                        exact: 600
                    }
                }
            });
            Webcam.attach('#my_camera');  --}}

            $('#closeModal').modal('show');
        })

        $('.closeModal').on('click', function(e) {
            e.preventDefault();
            Webcam.reset();
            $('#closeModal').modal('hide')
        });

        function take_snapshot() {
            Webcam.snap(function(data_uri) {
                $(".capture_image").val(data_uri);
                Webcam.freeze();
            });
        }

        function retake_snapshot() {
            Webcam.unfreeze();
        }
    </script>
    <script>
        var loadFile = function(event) {
            var reader = new FileReader();
            reader.onload = function() {
                var output = document.getElementById('output');
                output.src = reader.result;
            };
            reader.readAsDataURL(event.target.files[0]);
        };
    </script>
@endsection
