<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Backend\ProjectController;
use App\Http\Controllers\Backend\CustomerController;
use App\Http\Controllers\Backend\EmployeeController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\AttendanceController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
 */

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('check-playground', [HomeController::class, 'index']);

Route::group(['middleware' => ['auth', 'verified']], function () {
    Route::get('dashboard', [DashboardController::class, 'dashboard'])->name('dashboard');
    Route::get('profile', [DashboardController::class, 'profile'])->name('profile');
    Route::post('language-update', [DashboardController::class, 'language'])->name('language.update');
    Route::post('attendance-update', [DashboardController::class, 'attendance'])->name('attendance.update');

    Route::resource('employees', EmployeeController::class)->except(['show']);
    Route::post('projects/close', [ProjectController::class, 'close'])->name('projects.close');
    Route::get('projects/download/{id}', [ProjectController::class, 'download'])->name('projects.download');
    Route::get('projects/final-download/{id}', [ProjectController::class, 'finalDownload'])->name('projects.final-download');
    Route::post('projects/discussions', [ProjectController::class, 'discussions'])->name('projects.discussions');
    Route::delete('projects/discussions/delete/{id}', [ProjectController::class, 'deleteDiscussion'])->name('projects.discussions.delete');
    Route::get('projects/discussions/download/{id}', [ProjectController::class, 'discussionDownload'])->name('projects.discussions.download');
    Route::get('projects/pdf/{id}', [ProjectController::class, 'pdf'])->name('projects.pdf');
    Route::resource('projects', ProjectController::class);

    Route::resource('customers', CustomerController::class)->except(['show']);

    Route::get('attend-list', [AttendanceController::class, 'index'])->name('attend.list');
    Route::post('attend-submit', [AttendanceController::class, 'submit'])->name('attend.submit');
    Route::get('attend-punch-in-download/{id}', [AttendanceController::class, 'punchInDownload'])->name('attend.punch-in.download');
    Route::get('attend-punch-out-download/{id}', [AttendanceController::class, 'punchOutDownload'])->name('attend.punch-out.download');

    Route::get('report-index', [DashboardController::class, 'report'])->name('report.index');
    Route::post('report-pdf', [DashboardController::class, 'exportPdf'])->name('report.pdf');
    Route::delete('report-delete', [DashboardController::class, 'deleteReport'])->name('report.delete');
});
