<?php $__env->startSection('content'); ?>
    <div class="theme-body">
        <div class="custom-container">
            <div class="row">
                <div class="col-md-12">
                    
                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                        <div class="card">
                            <div class="card-header">
                                <h4><?php echo e(__('Update System Language')); ?></h4>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('language.update')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label class="form-label" for="name"><?php echo e(__('Select Language')); ?></label>
                                        <select class="form-control" name="lang">
                                            <option value="en" <?php echo e(session()->get('locale') == 'en' ? 'selected' : ''); ?>>English</option>
                                            <option value="it" <?php echo e(session()->get('locale') == 'it' ? 'selected' : ''); ?>>Italian</option>
                                        </select>
                                    </div>
                                    <button class="btn btn-primary" type="submit"><i class="fa fas fa-language"></i> <?php echo e(trans('Update Language')); ?></button>
                                </form>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h4><?php echo e(__('Attendance')); ?></h4>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('attendance.update')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label class="form-label" for="name"><?php echo e(__('Select Attendance')); ?></label>
                                        <select class="form-control" name="attend">
                                            <option value="1" <?php echo e(config('services.attendance') == 'enabled' ? 'selected' : ''); ?>><?php echo app('translator')->get('Enabled'); ?></option>
                                            <option value="0" <?php echo e(config('services.attendance') == 'disabled' ? 'selected' : ''); ?>><?php echo app('translator')->get('Disabled'); ?></option>
                                        </select>
                                    </div>
                                    <button class="btn btn-primary" type="submit"><i class="fa fa-calendar"></i> <?php echo e(trans('Save')); ?></button>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo app('translator')->get('Update Profile Information'); ?></h4>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('user-profile-information.update')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <div class="form-group">
                                    <label class="form-label" for="name"><?php echo e(__('Name')); ?></label>
                                    <input class="form-control" type="text" id="name" name="name" value="<?php echo e($user->name); ?>" placeholder="Name">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="email"><?php echo e(__('Email Address')); ?></label>
                                    <input class="form-control" type="email" id="email" name="email" value="<?php echo e($user->email); ?>" placeholder="Email">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <button class="btn btn-primary" type="submit"><i class="fa fa-send"></i> <?php echo app('translator')->get('Update Information'); ?></button>
                            </form>
                        </div>
                    </div>
                    
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo app('translator')->get('Update Password'); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            <form action="<?php echo e(route('user-password.update')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <div class="form-group">
                                    <label class="form-label" for="current-password"><?php echo e(__('Current Password')); ?></label>
                                    <div class="input-group group-input">
                                        <input class="form-control <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="current_password" name="current_password" type="password" placeholder="<?php echo e(__('Current Password')); ?>" required autocomplete="current-password">
                                        <span class="input-group-text fa fa-key"></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="Password"><?php echo e(__('Password')); ?></label>
                                    <div class="input-group group-input">
                                        <input class="form-control showhide-password <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="password" name="password" type="password" placeholder="<?php echo e(__('Password')); ?>" required autocomplete="new-password">
                                        <span class="input-group-text toggle-show fa fa-eye"></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="Password-confirm"><?php echo e(__('Confirm Password')); ?></label>
                                    <div class="input-group group-input">
                                        <input class="form-control showhide-password2" id="Password-confirm" name="password_confirmation" type="password" placeholder="<?php echo e(__('Confirm Password')); ?>" required autocomplete="new-password">
                                        <span class="input-group-text toggle-show2 fa fa-eye"></span>
                                    </div>
                                </div>
                                <button class="btn btn-primary" type="submit"><i class="fa fa-key"></i> <?php echo app('translator')->get('Update Password'); ?></button>
                            </form>
                        </div>
                    </div>
                    
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo app('translator')->get('2FA Management'); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php if(!auth()->user()->two_factor_secret): ?>
                                <form method="post" action="<?php echo e(url('/user/two-factor-authentication')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-success"><?php echo app('translator')->get('Click here to Enable 2FA'); ?></button>
                                </form>
                            <?php else: ?>
                                <?php if(session('status') == 'two-factor-authentication-enabled'): ?>
                                    <div class="alert alert-success" role="alert"><?php echo app('translator')->get('Please finish configuring two factor authentication below.'); ?></div>
                                <?php endif; ?>
                                <?php if(session('status') == 'two-factor-authentication-confirmed'): ?>
                                    <div class="alert alert-success" role="alert"><?php echo app('translator')->get('Two factor authentication confirmed and enabled successfully.'); ?></div>
                                <?php endif; ?>
                                
                                <?php if(!auth()->user()->two_factor_confirmed_at): ?>
                                    <div class="pb-3">
                                        <?php echo auth()->user()->twoFactorQrCodeSvg(); ?>

                                    </div>
                                    <div class="mt-10">
                                        <h3 class="py-10">Recovery Codes:</h3>
                                        <ul class="list-group mb-2">
                                            <?php $__currentLoopData = json_decode(decrypt(auth()->user()->two_factor_recovery_codes)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="list-group-item"><?php echo e($code); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                    <form method="post" class="pt-20" action="<?php echo e(url('/user/confirmed-two-factor-authentication')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label for="code" class="form-label"><?php echo app('translator')->get('Enter OTP Code'); ?></label>
                                            <input type="text" name="code" id="code" value="<?php echo e(old('code')); ?>" placeholder="<?php echo app('translator')->get('Enter OTP Code'); ?>" class="form-control" required>
                                        </div>
                                        <button type="button" class="btn btn-success mb-2"><?php echo app('translator')->get('Click here to Confirm 2FA'); ?></button>
                                    </form>
                                <?php endif; ?>

                                
                                <?php if(auth()->user()->two_factor_secret): ?>
                                    <h4 class="py-10"><?php echo app('translator')->get('If you want to remove the 2FA authentication'); ?></h4>
                                    <form method="post" action="<?php echo e(url('/user/two-factor-authentication')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger"><?php echo app('translator')->get('Click here to Disable 2FA'); ?></button>
                                    </form>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xbgqgjmd/public_html/resources/views/backend/settings/profile.blade.php ENDPATH**/ ?>